DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT	@FACILITY_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON O.PFK_ORGANIZATION = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

		CREATE TABLE #ACT(ACT_ID_EVN INT, ACT_ID_REQ INT)
		INSERT INTO #ACT(ACT_ID_EVN, ACT_ID_REQ)
		SELECT A.ID, A.PARENT_ACT_ID
		FROM BMS.dbo.ACT AS A
		INNER JOIN BMS.dbo.TRANSFER_EVN AS EVN ON EVN.ACT_ID = A.ID
		INNER JOIN BMS.dbo.TRANSFER_REQ AS REQ ON REQ.ACT_ID = A.PARENT_ACT_ID
		WHERE REQ.FACILITY_UID = @FACILITY_UID

		--DELETE TRANSFER EVN
		DELETE EVN FROM BMS.dbo.TRANSFER_EVN AS EVN
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID_EVN = EVN.ACT_ID

		DELETE ACT FROM BMS.dbo.ACT AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID_EVN = ACT.ID		

		--DELETE TRANSFER REQ
		DELETE REQ FROM BMS.dbo.TRANSFER_REQ AS REQ
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID_REQ = REQ.ACT_ID

		DELETE ACT FROM BMS.dbo.ACT AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID_REQ = ACT.ID

		--DELETE FROM BMS_HISTORY DATABASE
		DELETE EVN FROM BMS_HISTORY.dbo.TRANSFER_EVN_H AS EVN
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID_EVN = EVN.ACT_ID

		DELETE ACT FROM BMS_HISTORY.dbo.ACT_H AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID_EVN = ACT.ID		

		DELETE REQ FROM BMS_HISTORY.dbo.TRANSFER_REQ_H AS REQ
		INNER JOIN #ACT AS ACT ON ACT.ACT_ID_REQ = REQ.ACT_ID

		DELETE ACT FROM BMS_HISTORY.dbo.ACT_H AS ACT
		INNER JOIN #ACT AS A ON A.ACT_ID_REQ = ACT.ID	
		
		DROP TABLE #ACT
	SELECT 'Finalized VISN Waiting List - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
	