DECLARE @VISTA_CODE NVARCHAR(20), @VISTA_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'
		SELECT @VISTA_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
		WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

		CREATE TABLE #BED(ID INT)
		INSERT INTO #BED(ID)
		SELECT P.PFK_PLACE FROM BMS_EIS.dbo.EHL7_PLACE P
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON P.PFK_PLACE = R.FK_PLAYER_ENTITY AND R.CLASS_CODE = 'LOCE'
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS RW ON R.FK_SCOPER_ENTITY = RW.FK_PLAYER_ENTITY AND RW.CLASS_CODE = 'OWN'
		INNER JOIN BMS_EIS.dbo.ENTITY AS VS ON RW.FK_SCOPER_ENTITY = VS.PK_ENTITY
		WHERE P.CODE_CODE = 'BED'  AND VS.IDENTIFIER = @VISTA_UID

		--DELETE ROLE
		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #BED AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY

		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #BED AS DEL ON DEL.ID = ROL.FK_SCOPER_ENTITY

		--DELETE TRAIT
		DELETE TV FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
		INNER JOIN #BED AS DEL ON DEL.ID = TV.FK_ENTITY
		
		--DELETE UID
		DELETE OUID FROM BMS_EIS.dbo.EHL7_UID AS OUID
		INNER JOIN #BED AS DEL ON DEL.ID = OUID.FK_ENTITY
		
		--DELETE PLACE
		DELETE P FROM BMS_EIS.dbo.EHL7_PLACE AS P
		INNER JOIN #BED AS DEL ON DEL.ID = P.PFK_PLACE

		--DELETE ENTITY
		DELETE E FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN #BED AS DEL ON DEL.ID = E.PK_ENTITY

		DROP TABLE #BED
		
		--DELETE BED UNAVAILABLE FROM VISTA
		CREATE TABLE #BED_UNAV(ID INT, FLOW_ID UNIQUEIDENTIFIER)
		INSERT INTO #BED_UNAV(ID, FLOW_ID)
		SELECT BU.ACT_ID, A.FLOW_ID FROM BMS.dbo.BED_UNAVAILABLE AS BU
		INNER JOIN BMS.dbo.ACT AS A ON A.ID = BU.ACT_ID
		WHERE BU.IS_UNAVAILABLE_FROM_VISTA = 1 AND VISTA_SITE_UID = @VISTA_UID
		
		CREATE TABLE #BU_WARD(ID INT)
		INSERT INTO #BU_WARD
		SELECT BU_W.ID FROM BMS.dbo.BED_UNAVAILABLE_WARD AS BU_W
		INNER JOIN #BED_UNAV AS DEL ON DEL.ID = BU_W.BED_UNAVAILABLE_ID 

		--DELETE FROM BMS DATABASE
		DELETE BU_W FROM BMS.dbo.BED_UNAVAILABLE_WARD AS BU_W
		INNER JOIN #BU_WARD AS DEL ON DEL.ID = BU_W.ID

		DELETE BU FROM BMS.dbo.BED_UNAVAILABLE AS BU
		INNER JOIN #BED_UNAV AS DEL ON DEL.ID = BU.ACT_ID
		
		DELETE BU FROM BMS.dbo.ACT AS BU
		INNER JOIN #BED_UNAV AS DEL ON DEL.ID = BU.ID

		--DELETE FROM BMS_HISTORY
		DELETE BU_W FROM BMS_HISTORY.dbo.BED_UNAVAILABLE_WARD_H AS BU_W
		INNER JOIN #BU_WARD AS DEL ON DEL.ID = BU_W.ID

		DROP TABLE #BU_WARD

		DELETE BU FROM BMS_HISTORY.dbo.BED_UNAVAILABLE_H AS BU
		INNER JOIN #BED_UNAV AS DEL ON DEL.ID = BU.ACT_ID
		
		DELETE BU FROM BMS_HISTORY.dbo.ACT_H AS BU
		INNER JOIN #BED_UNAV AS DEL ON DEL.ID = BU.ID

		--DELETE FROM BMS_InstanceStore
		CREATE TABLE #SURROGATE_INSTANCE(SurrogateInstanceId INT)
		INSERT INTO #SURROGATE_INSTANCE(SurrogateInstanceId)
		SELECT SurrogateInstanceId FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS SI
		INNER JOIN #BED_UNAV AS ACT ON ACT.FLOW_ID = SI.Id  
		WHERE SI.BlockingBookmarks LIKE '%BMS.Workflows.WF.IBedUnavailableFlow%'

		DROP TABLE #BED_UNAV

		DELETE IPPT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancePromotedPropertiesTable] AS IPPT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IPPT.SurrogateInstanceId

		DELETE KT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[KeysTable] AS KT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = KT.SurrogateInstanceId

		DELETE IMCT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] AS IMCT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IMCT.SurrogateInstanceId

		DELETE RIT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[RunnableInstancesTable] AS RIT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = RIT.SurrogateInstanceId

		DELETE IT FROM [BMS_InstanceStore].[System.Activities.DurableInstancing].[InstancesTable] AS IT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON SI.SurrogateInstanceId = IT.SurrogateInstanceId

		DROP TABLE #SURROGATE_INSTANCE
		
		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 4
		SELECT 'Bed Room - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;



