﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace BMSConfigurationWarlock
{
    public class GeneralConfigurationModel : INotifyPropertyChanged
    {
        private string selectedVersion;
        private List<string> versions;
        private string servicesPort; 
        private string servicesServer;
        private string applicationName;
        private string databaseServer;
        private string webServer;
        private string servicesPrefix;
        private bool saveButtonVisible = true;

        public string SelectedVersion
        {
            get { return selectedVersion; }
            set
            {
                if(!string.IsNullOrEmpty(value))
                {
                    selectedVersion = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.SelectedVersion));
                }
            }
        }

        public List<string> Versions
        {
            get { return versions; }
            set { versions = value; }
        }

        public string  ServicesPort
        {
            get { return servicesPort; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    servicesPort = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.ServicesPort));
                }
            }
        }

        public string ServicesServer
        {
            get { return servicesServer; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    servicesServer = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.ServicesServer));
                }
            }
        }

        public string ApplicationName
        {
            get { return applicationName; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    applicationName = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.ApplicationName));
                }
            }
        }

        public string DatabaseServer
        {
            get { return databaseServer; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    databaseServer = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.DatabaseServer));
                }
            }
        }

        public string WebServer
        {
            get { return webServer; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    webServer = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.WebServer));
                }
            }
        }

        public string ServicesPrefix
        {
            get { return servicesPrefix; }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    servicesPrefix = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.ServicesPrefix));
                }
            }
        }

        public bool SaveButtonVisible
        {
            get { return saveButtonVisible; }
            set
            {
                if (saveButtonVisible != value)
                {
                    saveButtonVisible = value;
                    NotifyPropertyChanged(NameOf<GeneralConfigurationModel>.Property(e => e.SaveButtonVisible));
                }
            }
        }
        
        
        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

        #endregion
    }
}
