﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Core;
using Mdws2ORM.RpcQueries.Commands;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.RpcQueries
{
    public class EntryQuery : IEntryQuery
    {
        private readonly QuerySvcSoap client;
        private readonly VistASite vistaSite;

        public EntryQuery(QuerySvcSoap client, VistASite vistaSite)
        {
            this.client = client;
            this.vistaSite = vistaSite;
        }

        public IList<Entry> List(QueryParam param, ListParam listParam, VistASite vistaSite, string iens = "")
        {
            return ListerCommand.Execute(client, param, listParam, vistaSite, iens);
        }

        public Entry? Get(QueryParam param, GetParam getParam, VistASite vistaSite, string iens)
        {
            return GetsEntryDataCommand.Execute(client, param, getParam, vistaSite, iens);
        }
    }
}
