﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Exceptions;

namespace Mdws2ORM.RpcQueries.Commands.Util
{
    static class RpcUtilities
    {
        private const string NoDataText = "-1^No data retrieved\n";

        public static void CheckForFault(FaultTO fault)
        {
            if (fault != null)
                throw new QueryFaultException(fault);
        }

        public static void CheckForFault(TaggedTextArray taggedTextArray)
        {
            RpcUtilities.CheckForFault(taggedTextArray.fault);
            RpcUtilities.CheckForFault(taggedTextArray.results[0].fault);
        }

        public static bool IsResultEmpty(TaggedText text)
        {
            return text.text == NoDataText || text.text == string.Empty;
        }


    }
}
