﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Maps;
using System.Diagnostics;
using Mdws2ORM.Core;
using Mdws2ORM.RpcQueries.Commands.Util;
using Mdws2ORM.Exceptions;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.RpcQueries.Commands
{
    public static class GetsEntryDataCommand
    {
        private static string GetIenEntity(string iens)
        {
            int index = iens.IndexOf(',');
            return index > 0 ?
                iens.Substring(0, index) :
                iens;
        }

        public static Entry? Execute(QuerySvcSoap client, QueryParam queryParam, GetParam getParam, VistASite vistaSite, string iens)
        {
            if (iens[iens.Length - 1] != ',') 
                iens += ",";

            TaggedTextArray rpcResult = client.GETS_DIQ(
               queryParam.File,
               iens,
               queryParam.FieldParam,
               getParam.Flags);

            RpcUtilities.CheckForFault(rpcResult);
            TaggedText taggetText = rpcResult.results[0];

            if (RpcUtilities.IsResultEmpty(taggetText))
                return null;

            IEnumerable<Line> lines = TextParser.GetLines(taggetText.text);
            return ProcessLines(queryParam, iens, lines); ;
        }

        private static string GetMultipleLineValue(Line line, IEnumerator<Line> linesEnum, out bool hasNextOut)
        {
            StringBuilder sb = new StringBuilder(line.Value);
            bool hasNext;
            do
            {
                sb.AppendLine();
                sb.Append(linesEnum.Current.Value);
                hasNext = linesEnum.MoveNext();
            }
            while (hasNext && linesEnum.Current.Field == line.Field);
            hasNextOut = hasNext;
            return sb.ToString();
        }

        private static Entry ProcessLines(QueryParam queryParam, string iens, IEnumerable<Line> lines)
        {
            string ien = GetIenEntity(iens);
            string file = queryParam.File;
            string[] fields = queryParam.Fields;

            Entry.Field[] entryFields = new Entry.Field[fields.Length];
            int index = 0;

            IEnumerator<Line> linesEnum = lines.GetEnumerator();
            bool hasNext = linesEnum.MoveNext();

            while (hasNext)
            {
                Line line = linesEnum.Current;
                if (line.File != file)
                    throw new DataException(string.Format("Invalid input. File number {0} expected, but found {1}", file, line.File));

                while (fields[index] != line.Field)
                {
                    entryFields[index] = new Entry.Field(fields[index], string.Empty);
                    index++;
                }

                hasNext = linesEnum.MoveNext();
                string value = hasNext && linesEnum.Current.Field == line.Field ?
                    GetMultipleLineValue(line, linesEnum, out hasNext) : line.Value;

                entryFields[index] = new Entry.Field(line.Field, value);
                index++;

            }

            while (index < fields.Length)
            {
                entryFields[index] = new Entry.Field(fields[index], string.Empty);
                index++;
            }

            return new Entry(file, ien, entryFields);
        }


    }
}
