﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class NumericIntFieldMap<T> : BaseFieldMap<T> where T : class
    {
        private readonly Action<T, int> MapAction;

        public NumericIntFieldMap(string field, Action<T, int> mapAction)
            : base(field)
        {
            MapAction = mapAction;
        }

        public override void Map(IEntityQuery query, T entity, string value)
        {
            int intValue = int.Parse(value);
            MapAction(entity, intValue);
        }
    }
}
