﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class MultipleFieldMap<T, V> : BaseMultipleFieldMap<T>
        where T : class
        where V : class
    {
        private SubEntityMap<V> subEntityMap;
        private readonly Action<T, IEnumerable<V>> actionMap;

        public MultipleFieldMap(string field, Action<T, IEnumerable<V>> actionMap, SubEntityMap<V> subEntityMap = null)
            : base(field)
        {
            this.actionMap = actionMap;
            this.subEntityMap = subEntityMap;
        }


        public override void Map(IEntityQuery query, T parent, string iens)
        {
            if (!IsFetchEnabled) return;
            IEnumerable<V> entities = query.List(subEntityMap, FetchParam, iens).Select(s => s.Entity);
            actionMap(parent, entities);
        }

        public override void Init(InitMapMediator initMediator)
        {
            if (subEntityMap == null) subEntityMap = initMediator.GetSubEntityMap<V>();
            subEntityMap.Initialize(initMediator);          
        }

    }
}
