﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Core
{
    public static class SubEntityQuery
    {
        public static IEnumerable<T> GetSubEntities<T, P>(this IEntityQuery query, SubEntityMapWithParent<T, P> entityMap, ListParam param, P parent, string iens)
            where T : class
            where P : class
        {
            var list = query.List(entityMap, param, iens);
            return list.Select(s =>
            {
                entityMap.SetParent(s.Entity, parent);
                return s.Entity;
            });
        }

        public static IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(this IEntityQuery query, SubEntityMapWithParent<T, P> subEntityMap,BaseEntityMap<P> entityMap,  ListParam listParam, ListParam getParam, string iens = "")
            where T : class
            where P : class
        {
            var tuples = query.List(entityMap, listParam, iens);
            foreach (var tuple in tuples)
            {
                string getIens = Utilities.MakeListIens(tuple.Entry, iens);
                var subEntities = query.List(subEntityMap, getParam, getIens);
                foreach (var subTuple in subEntities)
                {
                    subEntityMap.SetParent(subTuple.Entity, tuple.Entity);
                    yield return new ListItem<T>(subTuple.Entity, tuple.Entry);
                }
            }
        }
    }
}
