use master

BEGIN TRY
	--ALTER DATABASE [$(varDataBaseName)] SET SINGLE_USER WITH ROLLBACK IMMEDIATE 

	DECLARE @job_id INT

	IF EXISTS (SELECT 1 from sys.databases AS SD
			WHERE SD.name = '$(varDataBaseName)' AND
							is_auto_update_stats_async_on = 1)
		ALTER DATABASE $(varDataBaseName) SET AUTO_UPDATE_STATISTICS_ASYNC OFF						

	SELECT @job_id = job_id
		FROM sys.databases AS SD
		INNER JOIN sys.dm_exec_background_job_queue AS JQ on SD.database_id = JQ.database_id
		WHERE SD.name = '$(varDataBaseName)' AND
			  is_auto_update_stats_async_on = 1

	IF @job_id IS NOT NULL
	BEGIN
		DECLARE @sql_kill_stats_job nvarchar(256)
		SET @sql_kill_stats_job = 'KILL STATS JOB ' + @job_id
		EXEC sp_executesql @sql_kill_stats_job
	END
END TRY
BEGIN CATCH
END CATCH

BEGIN TRY
	-- Kill all DB connections
	DECLARE @dbname sysname
	DECLARE @spid int

	SET @dbname = '$(varDataBaseName)'

	SELECT @spid = min(spid) from master.dbo.sysprocesses where dbid = db_id(@dbname)
	WHILE @spid IS NOT NULL
	BEGIN
	EXECUTE ('KILL ' + @spid)
	SELECT @spid = min(spid) from master.dbo.sysprocesses where dbid = db_id(@dbname) AND spid > @spid
	END

	DROP DATABASE [$(varDataBaseName)]
END TRY
BEGIN CATCH
END CATCH
-- Kill ended

/****** Object:  Database $(varDataBaseName)    Script Date: 11/29/2011 09:53:54 ******/
CREATE DATABASE $(varDataBaseName) ON  PRIMARY 
( NAME = N'$(varDataBaseName)_Data', FILENAME = N'$(varMoveDFToPath)\$(varDataBaseName)_Data.mdf' , SIZE = 102400KB , MAXSIZE = UNLIMITED, FILEGROWTH = 102400KB), 
	FILEGROUP [ftfg_evsCatalog] 
( NAME = N'$(varDataBaseName)_ftrow_evsCatalog', FILENAME = N'$(varMoveDFToPath)\$(varDataBaseName)_Data.ndf' , SIZE = 102400KB , MAXSIZE = UNLIMITED, FILEGROWTH = 102400KB)
	LOG ON 
( NAME = N'$(varDataBaseName)_Log', FILENAME = N'$(varMoveDFToPath)\$(varDataBaseName)_log.ldf' , SIZE = 102400KB , MAXSIZE = UNLIMITED, FILEGROWTH = 102400KB)
	
ALTER DATABASE $(varDataBaseName) SET COMPATIBILITY_LEVEL = 100
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [$(varDataBaseName)].[dbo].[sp_fulltext_database] @action = 'enable'
end
ALTER DATABASE $(varDataBaseName) SET ANSI_NULL_DEFAULT OFF
ALTER DATABASE $(varDataBaseName) SET ANSI_NULLS OFF
ALTER DATABASE $(varDataBaseName) SET ANSI_PADDING OFF
ALTER DATABASE $(varDataBaseName) SET ANSI_WARNINGS OFF
ALTER DATABASE $(varDataBaseName) SET ARITHABORT OFF
ALTER DATABASE $(varDataBaseName) SET AUTO_CLOSE OFF
ALTER DATABASE $(varDataBaseName) SET AUTO_CREATE_STATISTICS ON
ALTER DATABASE $(varDataBaseName) SET AUTO_SHRINK OFF
ALTER DATABASE $(varDataBaseName) SET AUTO_UPDATE_STATISTICS ON
ALTER DATABASE $(varDataBaseName) SET CURSOR_CLOSE_ON_COMMIT OFF
ALTER DATABASE $(varDataBaseName) SET CURSOR_DEFAULT  GLOBAL
ALTER DATABASE $(varDataBaseName) SET CONCAT_NULL_YIELDS_NULL OFF
ALTER DATABASE $(varDataBaseName) SET NUMERIC_ROUNDABORT OFF
ALTER DATABASE $(varDataBaseName) SET QUOTED_IDENTIFIER OFF
ALTER DATABASE $(varDataBaseName) SET RECURSIVE_TRIGGERS OFF
ALTER DATABASE $(varDataBaseName) SET  DISABLE_BROKER
ALTER DATABASE $(varDataBaseName) SET AUTO_UPDATE_STATISTICS_ASYNC OFF
ALTER DATABASE $(varDataBaseName) SET DATE_CORRELATION_OPTIMIZATION OFF
ALTER DATABASE $(varDataBaseName) SET TRUSTWORTHY OFF
ALTER DATABASE $(varDataBaseName) SET ALLOW_SNAPSHOT_ISOLATION OFF
ALTER DATABASE $(varDataBaseName) SET PARAMETERIZATION SIMPLE
ALTER DATABASE $(varDataBaseName) SET READ_COMMITTED_SNAPSHOT ON
ALTER DATABASE $(varDataBaseName) SET HONOR_BROKER_PRIORITY OFF
ALTER DATABASE $(varDataBaseName) SET  READ_WRITE
ALTER DATABASE $(varDataBaseName) SET RECOVERY SIMPLE
ALTER DATABASE $(varDataBaseName) SET  MULTI_USER
ALTER DATABASE $(varDataBaseName) SET PAGE_VERIFY CHECKSUM
ALTER DATABASE $(varDataBaseName) SET DB_CHAINING OFF