-- Columns

CREATE TABLE [dbo].[SCHEDULED_ADMISSION]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[PATIENT_ID] [int] NOT NULL,
[PATIENT_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RESERVATION_DATETIME] [datetime] NULL,
[LENGTH_OF_STAY_EXPECTED] [int] NULL,
[ADMITTING_DIAGNOSIS] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCHEDULER_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SURGERY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WARD_LOCATION_ID] [int] NULL,
[TREATING_SPECIALTY_ID] [int] NULL,
[WARD_OR_TREATING_SPECIALITY] [nvarchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCHEDULER_ID] [int] NULL,
[MEDICAL_CENTER_DIVISION_ID] [int] NULL,
[MEDICAL_CENTER_DIVISION_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DATETIME_CANCELLED] [datetime] NULL,
[PATIENT_MOVEMENT_ID] [int] NULL,
[PROVIDER_ID] [int] NULL,
[INTERNAL_UID] [uniqueidentifier] NULL,
)
GO
-- Triggers


CREATE TRIGGER [dbo].[SCHEDULED_ADMISSION_tgg_insert_update]
   ON  [dbo].[SCHEDULED_ADMISSION]
   AFTER insert,update
AS 
BEGIN	

	INSERT INTO [dbo].[WORKFLOW_LOG] ( SCHEDULED_ADMISSION_ID )

        SELECT IEN
          FROM inserted;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [PK_SCHEDULED_ADMISSION] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_MEDICAL_CENTER_DIVISION] FOREIGN KEY ([MEDICAL_CENTER_DIVISION_ID]) REFERENCES [dbo].[MEDICAL_CENTER_DIVISION] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_PATIENT] FOREIGN KEY ([PATIENT_ID]) REFERENCES [dbo].[PATIENT] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_PATIENT_MOVEMENT] FOREIGN KEY ([PATIENT_MOVEMENT_ID]) REFERENCES [dbo].[PATIENT_MOVEMENT] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_NEW_PERSON1] FOREIGN KEY ([PROVIDER_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_NEW_PERSON] FOREIGN KEY ([SCHEDULER_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_FAC_TREAT_SPECIALTY] FOREIGN KEY ([TREATING_SPECIALTY_ID]) REFERENCES [dbo].[FAC_TREAT_SPECIALTY] ([IEN])
GO
ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD CONSTRAINT [FK_SCHEDULED_ADMISSION_WARD_LOCATION] FOREIGN KEY ([WARD_LOCATION_ID]) REFERENCES [dbo].[WARD_LOCATION] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'The table contains data about the admissions scheduled for patients.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The list of diagnosis.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'ADMITTING_DIAGNOSIS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the admission was cancelled.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'DATETIME_CANCELLED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id column.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The length of stay (LOS) expected for the patient.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'LENGTH_OF_STAY_EXPECTED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the medical center division.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'MEDICAL_CENTER_DIVISION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the medical center division.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'MEDICAL_CENTER_DIVISION_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s id.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'PATIENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the patient movement act.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'PATIENT_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s name.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'PATIENT_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the reservation has been done.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'RESERVATION_DATETIME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the person (nurse or clerk).', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'SCHEDULER_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the person (nurse or clerk) that takes care of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'SCHEDULER_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The surgery.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'SURGERY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the treating specialty.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'TREATING_SPECIALTY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the ward location.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'WARD_LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the ward or treating specialty.', 'SCHEMA', N'dbo', 'TABLE', N'SCHEDULED_ADMISSION', 'COLUMN', N'WARD_OR_TREATING_SPECIALITY'
GO