-- Columns

CREATE TABLE [dbo].[ORDER_ACTIONS]
(
[DATE_TIME_ORDERED] [datetime] NOT NULL,
[ORDER_TEXT] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SIGNATURE_STATUS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DATE_TIME_SIGNED] [datetime] NULL,
[SIGNED_BY_ID] [int] NULL,
[NEW_PERSON_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PROVIDER_ID] [int] NULL,
[DATE_TIME_NURSE_VERIFIED] [datetime] NULL,
[VERIFYING_NURSE_ID] [int] NULL,
[DATE_TIME_CLERK_VERIFIED] [datetime] NULL,
[VERIFYING_CLERK_ID] [int] NULL,
[RELEASE_DATE_TIME] [datetime] NULL,
[RELEASE_STATUS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPRS_ORDER_ID] [int] NOT NULL
)
GO
-- Triggers


-- The trigger inserts in CPRS_ORDERS_LOG the rows updated in CPRS_ORDERS table.
CREATE TRIGGER [dbo].[ORDER_ACTIONS_tgg_insert_update]
   ON  [dbo].[ORDER_ACTIONS]
   AFTER insert,update
AS 
BEGIN	

	INSERT INTO [dbo].[WORKFLOW_LOG] ( CPRS_ORDERS_ID )

        SELECT CPRS_ORDER_ID
          FROM inserted;
END


GO
-- Constraints and Indexes

ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [PK_ORDER_ACTIONS] PRIMARY KEY CLUSTERED  ([CPRS_ORDER_ID])
GO
-- Foreign Keys

ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [FK_ORDER_ACTIONS_CPRS_ORDERS] FOREIGN KEY ([CPRS_ORDER_ID]) REFERENCES [dbo].[CPRS_ORDERS] ([IEN])
GO
ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [FK_ORDER_ACTIONS_NEW_PERSON1] FOREIGN KEY ([PROVIDER_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [FK_ORDER_ACTIONS_NEW_PERSON] FOREIGN KEY ([SIGNED_BY_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [FK_ORDER_ACTIONS_NEW_PERSON3] FOREIGN KEY ([VERIFYING_CLERK_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[ORDER_ACTIONS] ADD CONSTRAINT [FK_ORDER_ACTIONS_NEW_PERSON2] FOREIGN KEY ([VERIFYING_NURSE_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'The table contains data about order actions.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Foreign key to CPRS_ORDER table.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'CPRS_ORDER_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the clerk verified the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'DATE_TIME_CLERK_VERIFIED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the nurse verified the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'DATE_TIME_NURSE_VERIFIED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the order took place.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'DATE_TIME_ORDERED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the order has been signed.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'DATE_TIME_SIGNED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the person that signed the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'NEW_PERSON_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The content of the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'ORDER_TEXT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the provider.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'PROVIDER_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time the order is released.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'RELEASE_DATE_TIME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The status of the order release.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'RELEASE_STATUS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The status of the signature.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'SIGNATURE_STATUS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the person that signed the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'SIGNED_BY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the clerk person that verified the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'VERIFYING_CLERK_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the nurse that verified the order.', 'SCHEMA', N'dbo', 'TABLE', N'ORDER_ACTIONS', 'COLUMN', N'VERIFYING_NURSE_ID'
GO