CREATE TABLE [dbo].[HOSPITAL_LOCATION]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ABBREVIATION] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TELEPHONE] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[HOSPITAL_LOCATION_tgg_delete]
   ON  [dbo].[HOSPITAL_LOCATION]
   AFTER delete
AS 
BEGIN	
		insert into [dbo].[HOSPITAL_LOCATION_log]([ACTION], IEN, NAME, ABBREVIATION, TELEPHONE)
		select 'D', IEN, NAME, ABBREVIATION, TELEPHONE from deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[HOSPITAL_LOCATION_tgg_insert]
   ON  [dbo].[HOSPITAL_LOCATION]
   AFTER insert
AS 
BEGIN	
		insert into [dbo].[HOSPITAL_LOCATION_log]([ACTION], IEN, NAME, ABBREVIATION, TELEPHONE)
		select 'I', IEN, NAME, ABBREVIATION, TELEPHONE from inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[HOSPITAL_LOCATION_tgg_update]
   ON  [dbo].[HOSPITAL_LOCATION]
   AFTER update
AS 
BEGIN	
		insert into [dbo].[HOSPITAL_LOCATION_log]([ACTION], IEN, NAME, ABBREVIATION, TELEPHONE)
		select 'U', IEN, NAME, ABBREVIATION, TELEPHONE from inserted;
END
GO
ALTER TABLE [dbo].[HOSPITAL_LOCATION] ADD CONSTRAINT [PK_HOSPITAL_LOCATION] PRIMARY KEY CLUSTERED  ([IEN])
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains names and contact data of hospital locations.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The abbreviation of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION', 'COLUMN', N'ABBREVIATION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the location.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The telephone of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION', 'COLUMN', N'TELEPHONE'
GO
