SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

create view [System.Activities.DurableInstancing].[Instances] as
      select [InstancesTable].[Id] as [InstanceId],
             [PendingTimer],
             [CreationTime],
             [LastUpdated] as [LastUpdatedTime],
             [InstancesTable].[ServiceDeploymentId],
             [SuspensionExceptionName],
             [SuspensionReason],
             [BlockingBookmarks] as [ActiveBookmarks],
             case when [LockOwnersTable].[LockExpiration] > getutcdate()
				then [LockOwnersTable].[MachineName]
				else null
				end as [CurrentMachine],
             [LastMachineRunOn] as [LastMachine],
             [ExecutionStatus],
             [IsInitialized],
             [IsSuspended],
             [IsCompleted],
             [InstancesTable].[DataEncodingOption] as [EncodingOption],
             [PrimitiveDataProperties] as [ReadWritePrimitiveDataProperties],
             [WriteOnlyPrimitiveDataProperties],
             [ComplexDataProperties] as [ReadWriteComplexDataProperties],
             [WriteOnlyComplexDataProperties]
      from [System.Activities.DurableInstancing].[InstancesTable]
      left outer join [System.Activities.DurableInstancing].[LockOwnersTable]
      on [InstancesTable].[SurrogateLockOwnerId] = [LockOwnersTable].[SurrogateLockOwnerId]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

create trigger [System.Activities.DurableInstancing].[DeleteInstanceTrigger] on [System.Activities.DurableInstancing].[Instances]
instead of delete
as
begin	
	if (@@rowcount = 0)
		return
		
	set nocount on
	set transaction isolation level read committed		
	set xact_abort on;	
	
	declare @surrogateInstanceIds table ([SurrogateInstanceId] bigint primary key)		
	
	insert into @surrogateInstanceIds
	select [SurrogateInstanceId]
	from deleted as [DeletedInstances]
	join [InstancesTable] on [InstancesTable].[Id] = [DeletedInstances].[InstanceId]
	
	delete [InstancePromotedPropertiesTable]
	from @surrogateInstanceIds as [InstancesToDelete]
	inner merge join [System.Activities.DurableInstancing].[InstancePromotedPropertiesTable] on [InstancePromotedPropertiesTable].[SurrogateInstanceId] = [InstancesToDelete].[SurrogateInstanceId]
	
	delete [KeysTable]
	from @surrogateInstanceIds as [InstancesToDelete]
	inner loop join [System.Activities.DurableInstancing].[KeysTable] on [KeysTable].[SurrogateInstanceId] = [InstancesToDelete].[SurrogateInstanceId]
	
	delete from [InstanceMetadataChangesTable]
	from @surrogateInstanceIds as [InstancesToDelete]
	inner merge join [System.Activities.DurableInstancing].[InstanceMetadataChangesTable] on [InstanceMetadataChangesTable].[SurrogateInstanceId] = [InstancesToDelete].[SurrogateInstanceId]
	
	delete [RunnableInstancesTable]
	from @surrogateInstanceIds as [InstancesToDelete]
	inner loop join [System.Activities.DurableInstancing].[RunnableInstancesTable] on [RunnableInstancesTable].[SurrogateInstanceId] = [InstancesToDelete].[SurrogateInstanceId]
	
	delete [InstancesTable]
	from @surrogateInstanceIds as [InstancesToDelete]
	inner merge join [System.Activities.DurableInstancing].[InstancesTable] on [InstancesTable].[SurrogateInstanceId] = [InstancesToDelete].[SurrogateInstanceId]
end
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Instances view contains general information about all workflow Instances in the Database.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'If the workflow Instance is Idle, this property indicates what bookmarks the instance is blocked on. If the Instance is not idle, then this column is NULL.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'ActiveBookmarks'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates when the workflow was created.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'CreationTime'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the name of the computer which currently has the workflow Instance loaded in memory.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'CurrentMachine'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Describes the encoding used to serialize the data properties. 0 – No encoding, 1 – GzipStream', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'EncodingOption'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the current execution state of the Workflow. Possible states include Executing, Idle, Closed.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'ExecutionStatus'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ID of a workflow instance.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'InstanceId'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates whether the Workflow Instance has finished executing. 
Note: If the InstanceCompletionAction property is set to DeleteAll, the instances are removed from the view upon completion.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'IsCompleted'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates whether the workflow instance has been initialized. An initialized workflow instance is a workflow instance that has been persisted at least once.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'IsInitialized'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates whether the workflow instance has been suspended.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'IsSuspended'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the last computer that loaded the workflow instance.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'LastMachine'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the last time that the workflow was persisted to the database.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'LastUpdatedTime'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates that the workflow is blocked on a Delay activity and will be resumed after the timer expires. This value can be null if the workflow is not blocked waiting on a timer to expire.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'PendingTimer'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Contains serialized instance data properties that will be provided back to the workflow runtime when the instance is loaded.
A deserializer would require knowledge of all object types stored in this blob.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'ReadWriteComplexDataProperties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Contains serialized instance data properties that will be provided back to the workflow Runtime when the instance is loaded.
Each primitive property is a native CLR type, which means that no special assemblies are needed to deserialize the blob.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'ReadWritePrimitiveDataProperties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Acts as a foreign key to the [ServiceDeployments] view. If the current workflow instance is an instance of a web-hosted service, then this column has a value, otherwise it is set to NULL.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'ServiceDeploymentId'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the type of exception (e.g. InvalidOperationException) that caused the workflow to suspend.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'SuspensionExceptionName'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates why the Workflow Instance was suspended. If an exception caused the instance to suspend, then this column contains the message associated with the exception.
If the instance was manually suspended, then this column contains the user-specified reason for suspending the instance.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'SuspensionReason'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Contains serialized instance data properties that are not provided back to the workflow runtime when the instance is loaded.
A deserializer would require knowledge of all object types stored in this blob.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'WriteOnlyComplexDataProperties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Contains serialized instance data properties that are not provided back to the workflow runtime when the instance is loaded.
Each primitive property is a native CLR type, which means that no special assemblies are needed to deserialize the blob.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'Instances', 'COLUMN', N'WriteOnlyPrimitiveDataProperties'
GO
