CREATE TABLE [System.Activities.DurableInstancing].[RunnableInstancesTable]
(
[SurrogateInstanceId] [bigint] NOT NULL,
[WorkflowHostType] [uniqueidentifier] NULL,
[ServiceDeploymentId] [bigint] NULL,
[RunnableTime] [datetime] NOT NULL
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_RunnableInstancesTable_RunnableTime] ON [System.Activities.DurableInstancing].[RunnableInstancesTable] ([RunnableTime]) INCLUDE ([ServiceDeploymentId], [WorkflowHostType]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE UNIQUE CLUSTERED INDEX [CIX_RunnableInstancesTable_SurrogateInstanceId] ON [System.Activities.DurableInstancing].[RunnableInstancesTable] ([SurrogateInstanceId]) WITH (IGNORE_DUP_KEY=ON, ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_RunnableInstancesTable] ON [System.Activities.DurableInstancing].[RunnableInstancesTable] ([WorkflowHostType], [RunnableTime]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
