CREATE TABLE [dbo].[WAITING_LIST_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ACT_ID] [int] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[WAITING_AREA_ID] [int] NULL,
	[PROBLEM] [nvarchar](max) NULL,
	[FEE_DISPOSITION_ID] [int] NULL,
	[CONTRACT_FEE_ID] [int] NULL,
	[AUTHORIZED_FEE_ID] [int] NULL,
	[SERVICE_RECEIVING_FEE_ID] [int] NULL,
	[REASON_USING_FEE_ID] [int] NULL,
	[FEE_COMMENTS] [nvarchar](150) NULL,
	[REMOVED_DATE] [datetime] NULL,
	[TYPE_OF_BED_WARD] [nvarchar](250) NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL,
	[REQUESTED_BED_UID] [uniqueidentifier] NULL,
	[REQUESTED_BED_DATE] [datetime] NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[IS_IN_HOUSE] [bit] NULL,
	[IS_BED_IN_ISOLATION] [bit] NULL,
	[LAST_EDIT_BY] [nvarchar](100) NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[COMMENTS] [nvarchar](150) NULL,
	[WAIT_TIME_ALERT_DATE] [datetime] NULL,
	[IS_COMMUNITY_LIVING_CENTER] [bit] NULL,
	[IS_EVACUATION_PATIENT] [bit] NULL,
	[EVACUATION_DISPOSITION_STATUS_ID] [int] NULL,
	[EVACUATION_EXPECTED_DATE] [datetime] NULL,
	[EVACUATION_ACTUAL_DATE] [datetime] NULL,
	[EVACUATION_REASON_FOR_DELAY] [nvarchar](250) NULL,
	[EVACUATION_TRANSFER_EVACUATE_TO] [nvarchar](250) NULL,
	[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] [nvarchar](250) NULL,
	[EVACUATION_TRANSPORTATION_CARE_LEVEL] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[EVACUATION_TRANSPORTATION_TYPE_ID] [int] NULL,
	[EVACUATION_TRANSPORTATION_PROVIDER_ID] [int] NULL,
	[EVACUATION_TRANSPORTATION_COMMENTS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_ADDRESS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_CITY_STATE] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_ORIGINATOR_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_COMMENTS] [nvarchar](500) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] [int] NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] [int] NULL
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[WAITING_LIST_H] ADD CONSTRAINT [PK_WAITING_LIST_H] PRIMARY KEY CLUSTERED  ([PK])
GO
-- Extended Properties

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'PK'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ID of the admission and reference key to the ACT table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'ACT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the facility that was requested for the admission.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the area where the patient waits to be admitted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'WAITING_AREA_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the presented problem or diagnostic of  the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'PROBLEM'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee utilization - concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'FEE_DISPOSITION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the fee contract (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'CONTRACT_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the authorized fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'AUTHORIZED_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the service receiving fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'SERVICE_RECEIVING_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the reason using fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'REASON_USING_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'FEE_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Removed from waiting list date time.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'REMOVED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of bed or ward that the patient needs.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'TYPE_OF_BED_WARD'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'CREATED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed requested.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'REQUESTED_BED_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date when the bed was requested.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'REQUESTED_BED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient already admitted to current facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'IS_IN_HOUSE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether bed is in isolation or not.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'IS_BED_IN_ISOLATION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Wait time alert date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'WAIT_TIME_ALERT_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Community Living Center (CLC) patients and future scheduled patients' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'IS_COMMUNITY_LIVING_CENTER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether patient is in evacuation or not.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'IS_EVACUATION_PATIENT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation disposition status id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_DISPOSITION_STATUS_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation expected pick-up date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_EXPECTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation actual pick-up date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ACTUAL_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation reason fro delay.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_REASON_FOR_DELAY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation transfer/Evacuate to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSFER_EVACUATE_TO'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Equip/Supply Requirements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_EQUIP_SUPPLY_REQUIREMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Care Level.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_CARE_LEVEL'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Medical Attendant.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Non-Medical Attendant.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Type Id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_TYPE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Provider Id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_PROVIDER_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination Address.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_ADDRESS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination City/State.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_CITY_STATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination POC Phone.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_POC_TELEPHONE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Originator POC Phone.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ORIGINATOR_POC_TELEPHONE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Medical Attendant Number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Non-Medical Attendant Number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Admission request table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST_H'
GO


