CREATE TABLE [dbo].[DISCHARGE_INT_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [NVARCHAR] (50) NOT NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[DATE_ENTERED] [DATETIME] NOT NULL,
[IS_ACTIVE] [BIT] NOT NULL,
[APPOINTMENT_DATE] [datetime] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[HOSPITAL_LOCATION_UID] [UNIQUEIDENTIFIER] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STATUS] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[DISCHARGE_INT_H] ADD CONSTRAINT [PK_DISCHARGE_INT_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Discharge intent act.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date planned for the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'APPOINTMENT_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the discharge status.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'STATUS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The hospital location id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT_H', @level2type=N'COLUMN',@level2name=N'HOSPITAL_LOCATION_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Entered date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT_H', @level2type=N'COLUMN',@level2name=N'DATE_ENTERED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If order is active.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT_H', @level2type=N'COLUMN',@level2name=N'IS_ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the ward from where the patient will be discharged.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT_H', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'UID of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the intent was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT_H', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO