CREATE TABLE [dbo].[ACT_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1), 
[ID] [int] NOT NULL,
[PATIENT_UID] [uniqueidentifier] NULL,
[CREATION_DATE] [datetime] NULL,
[CANCELED_DATE] [datetime] NULL,
[PARENT_ACT_ID] [int] NULL,
[FLOW_ID] [uniqueidentifier] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] [datetime] NULL
)
GO
ALTER TABLE [dbo].[ACT_H] ADD CONSTRAINT [PK_ACT_H] PRIMARY KEY CLUSTERED  ([PK])
GO
EXEC sp_addextendedproperty N'MS_Description', N'Main entity for all documents (HL7 ACT).', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of cancellation.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'CANCELED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'CREATION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of acts.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the flow.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'FLOW_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Identity number and primary key of the transaction table.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN)', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the parent act.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'PARENT_ACT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'ACT_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO