CREATE TABLE [dbo].[ACTION_GROUP_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[GROUP_ID] [uniqueidentifier] NOT NULL,
[ACTION_ID] [uniqueidentifier] NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ACTION_GROUP_H] ADD CONSTRAINT [PK_ACTION_GROUP] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates actions to a group of actions.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of an action that is associated to the group.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'ACTION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the action which is a group of operations.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'GROUP_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_GROUP_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
