IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN
SET NOCOUNT ON;

BEGIN TRY
	
	DECLARE @SQL VARCHAR(max), @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT,  @START_DATE DATETIME
	--DROP TABLE DIM_ICON_FLAG_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_ETL]'))
	BEGIN
		DROP TABLE DIM_ICON_FLAG_ETL
	END
	
	--DISABLE INDEXES
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' DISABLE;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG';	
	EXEC (@SQL)
	
	SET @START_DATE = '1900-01-01'
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)	
		
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Dim_Icon_Flag](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Dim_Icon_Flag](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''') '')'
		
	SET @SQL = ''
	SET @SQL = @SQL + '
		SELECT [GROUP]
			  ,[SUBGROUP]
			  ,[APP_ICONS_CODE]
			  ,[IMAGE_BYTES]
			  ,[IMAGE_BYTES_INACTIVE]
			  ,[ORDER_INDEX]
			  ,[ACTIVE]
			  ,[PUBLISHED]
			  ,[PATIENT_OR_ROOMBED]
			  ,[IMAGE_NAME]
			  ,[ICON_NAME]
			  ,[SHORT_DESCRIPTION]
			  ,[LONG_DESCRIPTION]
			  ,[COMMENT]
			  ,[MOUSE_OVER_TEXT]
			  ,[ENTERED_BY]
			  ,[ENTERED_DATE]
			  ,[LAST_EDIT_BY]
			  ,[LAST_EDIT_DATE]
			  ,[SOURCE_ID]
			  ,[_SSIS_TIMESTAMP]
		INTO DIM_ICON_FLAG_ETL
		FROM ' + @FROM_CLAUSE
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_ETL]'))
	BEGIN
		--ADDED INDEXES ON TABLE DIM_ICON_FLAG_ETL
		CREATE NONCLUSTERED INDEX [idx_APP_ICONS_CODE] ON DIM_ICON_FLAG_ETL(APP_ICONS_CODE ASC)
		CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON DIM_ICON_FLAG_ETL(SOURCE_ID ASC)
 
		INSERT INTO [DIM_ICON_FLAG]
			   ([GROUP]
			   ,[SUBGROUP]
			   ,[DIM_APPLICATION_ICONS_ID]
			   ,[IMAGE_BYTES]
			   ,[IMAGE_BYTES_INACTIVE]
			   ,[ORDER_INDEX]
			   ,[ACTIVE]
			   ,[PUBLISHED]
			   ,[PATIENT_OR_ROOMBED]
			   ,[IMAGE_NAME]
			   ,[ICON_NAME]
			   ,[SHORT_DESCRIPTION]
			   ,[LONG_DESCRIPTION]
			   ,[COMMENT]
			   ,[MOUSE_OVER_TEXT]
			   ,[ENTERED_BY]
			   ,[ENTERED_DATE]
			   ,[LAST_EDIT_BY]
			   ,[LAST_EDIT_DATE]
			   ,[SOURCE_ID]
			   ,[_SSIS_TIMESTAMP])
		 SELECT [GROUP]
				 ,[SUBGROUP]
				 ,dap.ID
				 ,[IMAGE_BYTES]
				 ,[IMAGE_BYTES_INACTIVE]
				 ,[ORDER_INDEX]
				 ,[ACTIVE]
				 ,[PUBLISHED]
				 ,[PATIENT_OR_ROOMBED]
				 ,[IMAGE_NAME]
				 ,[ICON_NAME]
				 ,[SHORT_DESCRIPTION]
				 ,[LONG_DESCRIPTION]
				 ,[COMMENT]
				 ,[MOUSE_OVER_TEXT]
				 ,[ENTERED_BY]
				 ,[ENTERED_DATE]
				 ,[LAST_EDIT_BY]
				 ,[LAST_EDIT_DATE]
			   ,difi.[SOURCE_ID]
			   ,difi.[_SSIS_TIMESTAMP]
		FROM DIM_ICON_FLAG_ETL difi 
		LEFT JOIN dbo.DIM_APPLICATION_ICONS dap on dap.code = difi.APP_ICONS_CODE
	END
	
	--REBUILD INDEXES ON TABLE DIM_ICON_FLAG
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG';
	EXEC (@SQL)
	
	--TRUNCATE TABLE DIM_ICON_FLAG_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_ETL]'))
	BEGIN
		TRUNCATE TABLE DIM_ICON_FLAG_ETL
	END
	
	RETURN @ROWS
	
END TRY
BEGIN CATCH
	
	DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
			
	SELECT @ErrorMessage = '*** ERROR in usp_ETL_Full_Insert_Dim_Icon_Flag: ' + ERROR_MESSAGE(),
		   @ErrorSeverity = ERROR_SEVERITY(),
		   @ErrorState = ERROR_STATE();
	
	RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState) WITH LOG;
	
	--ENABLED INDEX
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG';
	EXEC (@SQL)

END CATCH	

END

GO


