
CREATE TABLE [dbo].[FACT_SPECIALTY_TRANSFER](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[IEN] [varchar](50) NULL,
	[DIM_PATIENT_ID] [int] NULL,
	[DIM_DOMAIN_ID] [int] NOT NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [int] NULL,
	[DATE_TIME] [datetime] NULL,
	[DIM_MOVEMENT_TYPE_ID] [int] NULL,
	[ENTERED_DATE] [datetime] NULL,
	[ENTERED_BY_DIM_PHYSICIAN_ID] [int] NULL,
	[SOURCE_ID] INT NOT NULL,
	[_ssis_timestamp] [datetime] NULL,
 CONSTRAINT [PK_BMS_SPECIALTY_TRANSFER] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_DOMAIN] FOREIGN KEY([DIM_DOMAIN_ID])
REFERENCES [dbo].[DIM_DOMAIN] ([ID])
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER] CHECK CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_DOMAIN]
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_ORGANIZATION] FOREIGN KEY([VISTA_SITE_DIM_ORGANIZATION_ID])
REFERENCES [dbo].[DIM_ORGANIZATION] ([ID])
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER] CHECK CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_ORGANIZATION]
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_PATIENT] FOREIGN KEY([DIM_PATIENT_ID])
REFERENCES [dbo].[DIM_PATIENT] ([ID])
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER] CHECK CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_PATIENT]
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_PHYSICIAN] FOREIGN KEY([ENTERED_BY_DIM_PHYSICIAN_ID])
REFERENCES [dbo].[DIM_PHYSICIAN] ([ID])
GO

ALTER TABLE [dbo].[FACT_SPECIALTY_TRANSFER] CHECK CONSTRAINT [FK_FACT_SPECIALTY_TRANSFER_DIM_PHYSICIAN]
GO


CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON FACT_SPECIALTY_TRANSFER(SOURCE_ID ASC)
GO