
CREATE TABLE [dbo].[FACT_TRANSFER_ETL](
	[DIM_PATIENT_ID] [nvarchar](250) NULL,
	[IEN] [varchar](50) NULL,
	[REQ_CREATION_DATE] [datetime] NULL,
	[REQ_CANCELED_DATE] [datetime] NULL,
	[EVN_CREATION_DATE] [datetime] NULL,
	[EVN_CANCELED_DATE] [datetime] NULL,
	[FACILITY_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[DIM_ERA_CODE] [varchar](100) NULL,
	[DIM_SPECIALTY_CODE] [varchar](100) NULL,
	[CURRENT_LOCATION] [nvarchar](150) NULL,
	[DIAGNOSIS] [nvarchar](250) NULL,
	[ADMISSION_FACILITY_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[DIM_DISPOSITION_CODE] [varchar](100) NULL,
	[REQ_COMMENTS] [nvarchar](250) NULL,
	[EVN_COMMENTS] [nvarchar](150) NULL,
	[DIM_DOMAIN_ID] [nvarchar](50) NOT NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[REQ_CONTRACT_CODE] [varchar](100) NULL,
	[REQ_LOCATION_ADMISSION_DATE] [datetime] NULL,
	[REQ_ENTERED_BY] [nvarchar](100) NULL,
	[REQ_LAST_EDIT_BY] [nvarchar](100) NULL,
	[REQ_EDITED] [datetime] NULL,
	[FACILITY_VISN] [nvarchar](100) NULL,
	[EVN_DISPOSITION_DATE] [datetime] NULL,
	[FLOW_ID] [uniqueidentifier] NOT NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[IS_NATIONAL_WAIT_LIST] [bit] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains temporary transfer information from bms database(Transfer_req and Transfer_evn). Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_TRANSFER_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_ADMISSION_FACILITY_DIM_ORGANIZATION_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[ADMISSION_FACILITY_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DISPOSITION_CODE] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[DIM_DISPOSITION_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[DIM_DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_ERA_CODE] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[DIM_ERA_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_SPECIALTY_CODE] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[DIM_SPECIALTY_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_FACILITY_DIM_ORGANIZATION_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[FACILITY_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_REQ_CONTRACT_CODE] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[REQ_CONTRACT_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_TRANSFER_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO