CREATE TABLE [dbo].[FACT_BED_SWITCH_ETL](
	[DOMAIN_ID] [nvarchar](50) NULL,
	[IEN] [varchar](50) NULL,
	[DIM_PATIENT_ID] [nvarchar](250) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[DIM_WARD_ID] [nvarchar](250) NULL,
	[DIM_BED_ID] [nvarchar](250) NULL,
	[DIM_OLD_BED_ID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[ADM_SOURCE_ID] [int] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update bed switch table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_BED_SWITCH_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_ADM_SOURCE_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[ADM_SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_BED_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[DIM_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_OLD_BED_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[DIM_OLD_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_WARD_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[DIM_WARD_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_BED_SWITCH_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
