CREATE TABLE [dbo].[FACT_ADMISSION_REQ_ETL](
	[IEN] [varchar](50) NULL,
	[DIM_PATIENT_ID] [nvarchar](250) NULL,
	[ORDERED_DATE] [datetime] NOT NULL,
	[HOSPITAL_LOCATION_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[PROVIDER_DIM_PHYSICIAN_ID] [nvarchar](250) NULL,
	[SIGNED_DATE] [datetime] NULL,
	[RELEASED_DATE] [datetime] NULL,
	[ORDER_TEXT] [nvarchar](max) NULL,
	[DIM_DOMAIN_ID] [nvarchar](50) NOT NULL,
	[SIGNED_BY_DIM_PHYSICIAN_ID] [nvarchar](250) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[IS_ACTIVE] [bit] NOT NULL,
	[WARD_DIM_WARD_ID] [nvarchar](250) NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update admission request table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_ADMISSION_REQ_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[DIM_DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_HOSPITAL_LOCATION_DIM_ORGANIZATION_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[HOSPITAL_LOCATION_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PROVIDER_DIM_PHYSICIAN_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[PROVIDER_DIM_PHYSICIAN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SIGNED_BY_DIM_PHYSICIAN_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[SIGNED_BY_DIM_PHYSICIAN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_WARD_DIM_WARD_ID] ON [dbo].[FACT_ADMISSION_REQ_ETL] 
(
	[WARD_DIM_WARD_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO