
CREATE TABLE [dbo].[BMS_ICON_FLAG_FACILITY](
	[ID] [int] NOT NULL,
	[ICON_FLAG_ID] [int] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[ORDER_INDEX] [int] NOT NULL,
	[ACTIVE] [bit] NOT NULL,
	[PATIENT_OR_ROOMBED] [char](1) NOT NULL,
	[ICON_NAME] [nvarchar](150) NULL,
	[DESCRIPTION] [nvarchar](max) NULL,
	[COMMENT] [nvarchar](150) NULL,
	[MOUSE_OVER_TEXT] [nvarchar](150) NULL,
	[ENTERED_BY] [nvarchar](50) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[_ssis_timestamp] [datetime] NULL,
	[_isDeleted] [bit] NULL DEFAULT ((0)),
 CONSTRAINT [PK_BMS_ICON_FLAG_FACILITY] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the icon from the icon definitions table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ICON_FLAG_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order of the icons on the screen per subgroup.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ORDER_INDEX'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag for an active/inactive icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ACTIVE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'PATIENT_OR_ROOMBED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ICON_NAME'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'DESCRIPTION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text comment appropriate for the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'COMMENT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text to show on the top of the icon (hover text).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'MOUSE_OVER_TEXT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who inserted the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon inserted datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ENTERED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the icon was last edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This flag tells if the record has been deleted from the initial database table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'_isDeleted'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores icon attributes specific to a facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BMS_ICON_FLAG_FACILITY'
GO

CREATE NONCLUSTERED INDEX [idx_ssis_timestamp_isDeleted] ON BMS_ICON_FLAG_FACILITY(_ssis_timestamp ASC, _isDeleted asc)
GO
CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_ID] ON BMS_ICON_FLAG_FACILITY(ICON_FLAG_ID ASC)
GO
ALTER TABLE [dbo].[BMS_ICON_FLAG_FACILITY] ADD CONSTRAINT [DF_BMS_ICON_F_F_ACTIVE] DEFAULT (0) FOR [ACTIVE]
GO
ALTER TABLE [dbo].[BMS_ICON_FLAG_FACILITY] ADD CONSTRAINT [DF_BMS_ICON_F_F_ICON_FLAG_ID] DEFAULT (0) FOR [ICON_FLAG_ID]
GO
ALTER TABLE [dbo].[BMS_ICON_FLAG_FACILITY] ADD CONSTRAINT [DF_BMS_ICON_F_F_FACILITY_UID] DEFAULT (CAST(CAST(0 AS BINARY) AS UNIQUEIDENTIFIER)) FOR [FACILITY_UID]
GO
ALTER TABLE [dbo].[BMS_ICON_FLAG_FACILITY] ADD CONSTRAINT [DF_BMS_ICON_F_F_ORDER_INDEX] DEFAULT (0) FOR [ORDER_INDEX]
GO
ALTER TABLE [dbo].[BMS_ICON_FLAG_FACILITY] ADD CONSTRAINT [DF_BMS_ICON_F_F_PATIENT_OR_ROOMBED] DEFAULT (' ') FOR [PATIENT_OR_ROOMBED]
GO