CREATE TABLE [dbo].[VISTA_INTEGRATION_LOG](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[IEN] [nvarchar](50) NULL,
	[VISTA] [nvarchar](50) NULL,
	[VISTA_FILE] [char](2) NULL,
 CONSTRAINT [PK_VISTA_INTEGRATION_LOG] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE NONCLUSTERED INDEX [IDX_IEN_VISTA] ON [dbo].[VISTA_INTEGRATION_LOG] 
(
	[IEN] ASC,
	[VISTA] ASC
)
INCLUDE ( [VISTA_FILE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_INTEGRATION_LOG', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the processed record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_INTEGRATION_LOG', @level2type=N'COLUMN',@level2name=N'IEN'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the vista.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_INTEGRATION_LOG', @level2type=N'COLUMN',@level2name=N'VISTA'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista file.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_INTEGRATION_LOG', @level2type=N'COLUMN',@level2name=N'VISTA_FILE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores each processed record from the vista file specified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_INTEGRATION_LOG'
GO