CREATE TABLE [dbo].[ROLE]
(
[ID] [uniqueidentifier] NOT NULL,
[NAME] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Role_AfterDelete] 
   ON  [dbo].[ROLE] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Role_H]
			   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Role_AfterInsert] 
   ON  [dbo].[ROLE] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Role_H]
			   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Role_AfterUpdate] 
   ON  [dbo].[ROLE] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Role_H]
			   (ID, NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Role_InsteadOfInsert] 
   ON  [dbo].[ROLE]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     INSERT INTO [dbo].[Role]
			   (ID, NAME, CREATED, CREATEDBY)
			SELECT ID, NAME, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	 
	ELSE
		INSERT INTO [dbo].[Role]
			   (ID, NAME)
			SELECT ID, NAME
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Role_InsteadOfUpdate] 
   ON  [dbo].[ROLE] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Role]
		SET NAME = inserted.NAME,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Role]
		INNER JOIN inserted ON inserted.id = [dbo].[Role].id;
	
	 ELSE
	    UPDATE [dbo].[Role]
		SET NAME = inserted.NAME
		FROM [dbo].[Role]
		INNER JOIN inserted ON inserted.id = [dbo].[Role].id;

END
GO
ALTER TABLE [dbo].[ROLE] ADD CONSTRAINT [PK_ROLE] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains roles.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Role id.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Role name.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ROLE', 'COLUMN', N'UPDATEDBY'
GO
