CREATE TABLE [dbo].[SECURITY_CONTEXT]
(
[SPID] [int] NOT NULL,
[USER_GROUP_ID] [varchar] (8000) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DOMAIN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SUPERUSER] [bit] NULL CONSTRAINT [DF_SECURITY_CONTEXT_SUPERUSER] DEFAULT ((0)),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Security_Context_AfterDelete] 
   ON  [dbo].[SECURITY_CONTEXT] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Security_Context_H]
			   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
			
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Security_Context_AfterInsert] 
   ON  [dbo].[SECURITY_CONTEXT] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Security_Context_H]
			   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Security_Context_AfterUpdate] 
   ON  [dbo].[SECURITY_CONTEXT] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	  INSERT INTO $(varBMS_HISTORY).[dbo].[Security_Context_H]
			   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Security_Context_InsteadOfInsert] 
   ON  [dbo].[SECURITY_CONTEXT]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     INSERT INTO [dbo].[Security_Context]
			   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, CREATED, CREATEDBY)
			SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	 
	ELSE
		INSERT INTO [dbo].[Security_Context]
			   (SPID, USER_GROUP_ID, DOMAIN, SUPERUSER)
			SELECT SPID, USER_GROUP_ID, DOMAIN, SUPERUSER
			  FROM inserted;
	
END
GO
CREATE NONCLUSTERED INDEX [IX_SECURITY_CONTEXT] ON [dbo].[SECURITY_CONTEXT] ([SPID]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains the security context.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Domain name.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'DOMAIN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table''s identifier.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'SPID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'True or false if it is super user or not.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'SUPERUSER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the user group.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT', 'COLUMN', N'USER_GROUP_ID'
GO
