CREATE TABLE [dbo].[CONFIG_EVS]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[CONFIG_ID] [int] NOT NULL,
[CODE] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM_NAME] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DISPLAY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EVS_AfterDelete] 
   ON  [dbo].[CONFIG_EVS] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EVS_H]
			   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EVS_AfterInsert] 
   ON  [dbo].[CONFIG_EVS] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EVS_H]
			   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
       
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EVS_AfterUpdate] 
   ON  [dbo].[CONFIG_EVS] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EVS_H]
			   (ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_EVS_InsteadOfInsert] 
   ON  [dbo].[CONFIG_EVS]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Config_EVS]
			   (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, CREATED, CREATEDBY)
			SELECT CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[Config_EVS]
			   (CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
			SELECT CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_EVS_InsteadOfUpdate] 
   ON  [dbo].[CONFIG_EVS] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 UPDATE [dbo].[Config_EVS]
		SET CONFIG_ID = inserted.CONFIG_ID,
			CODE = inserted.CODE,
			CODE_SYSTEM = inserted.CODE_SYSTEM,
			CODE_SYSTEM_NAME = inserted.CODE_SYSTEM_NAME,
			DISPLAY_NAME = inserted.DISPLAY_NAME,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Config_EVS]
		INNER JOIN inserted ON inserted.id = [dbo].[Config_EVS].id;
	
	 ELSE
	    UPDATE [dbo].[Config_EVS]
		SET CONFIG_ID = inserted.CONFIG_ID,
			CODE = inserted.CODE,
			CODE_SYSTEM = inserted.CODE_SYSTEM,
			CODE_SYSTEM_NAME = inserted.CODE_SYSTEM_NAME,
			DISPLAY_NAME = inserted.DISPLAY_NAME
		FROM [dbo].[Config_EVS]
		INNER JOIN inserted ON inserted.id = [dbo].[Config_EVS].id;

END
GO

--Constraints
ALTER TABLE [dbo].[CONFIG_EVS] ADD CONSTRAINT [PK_CONFIG_EVS] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONFIG_EVS] ADD CONSTRAINT [FK_CONFIG_EVS_CONFIG] FOREIGN KEY ([CONFIG_ID]) REFERENCES [dbo].[CONFIG] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_CONFIG_ID] ON [dbo].[CONFIG_EVS] 
(
	[CONFIG_ID] ASC
)
INCLUDE ( [ID],
[CODE],
[CODE_SYSTEM],
[CODE_SYSTEM_NAME],
[DISPLAY_NAME]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Configuration table for vocabularies.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code system.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CODE_SYSTEM'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code system name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CODE_SYSTEM_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Parent configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CONFIG_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s display name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'DISPLAY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s configuration id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS', 'COLUMN', N'UPDATEDBY'
GO
