-- Columns

CREATE TABLE [dbo].[ADMISSION_LEVEL_OF_CARE]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[ADMISSION_ID] [int] NOT NULL,
[LEVEL_OF_CARE] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_DATE] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_ADMISSION_LEVEL_OF_CARE__ssis_timestamp] DEFAULT (getdate()),
[CREATEDBY] [nvarchar](50) NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar](50) NULL,
[UPDATED] [datetime] NULL,
)
GO
-- Triggers

CREATE trigger [dbo].[ADMISSION_LEVEL_OF_CARE_tgg_ssis_delete] on [dbo].[ADMISSION_LEVEL_OF_CARE] 
	after delete 
	as 
	begin  
		delete [dbo].[ADMISSION_LEVEL_OF_CARE_ssisdel] from [deleted] _xyz where [dbo].[ADMISSION_LEVEL_OF_CARE_ssisdel].[ID]=[_xyz].[ID];  
		insert into [dbo].[ADMISSION_LEVEL_OF_CARE_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  
	end
GO

CREATE trigger [dbo].[ADMISSION_LEVEL_OF_CARE_tgg_ssis_insert] on [dbo].[ADMISSION_LEVEL_OF_CARE] 
	after insert 
	as 
	begin 
		delete [dbo].[ADMISSION_LEVEL_OF_CARE_ssisdel]  from [inserted] _xyz where [dbo].[ADMISSION_LEVEL_OF_CARE_ssisdel].[ID]=[_xyz].[ID] 
	end
GO

CREATE TRIGGER [dbo].[utg_Admission_Level_Of_Care_AfterDelete] 
   ON  [dbo].[ADMISSION_LEVEL_OF_CARE] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		BEGIN 
			INSERT INTO $(varBMS_HISTORY).[dbo].[ADMISSION_LEVEL_OF_CARE_H]
				(ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT	ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM deleted;
		END		
END
GO

CREATE TRIGGER [dbo].[utg_Admission_Level_Of_Care_AfterInsert] 
   ON  [dbo].[ADMISSION_LEVEL_OF_CARE] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ADMISSION_LEVEL_OF_CARE_H]
			(ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO

CREATE TRIGGER [dbo].[utg_Admission_Level_Of_Care_AfterUpdate] 
   ON  [dbo].[ADMISSION_LEVEL_OF_CARE] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ADMISSION_LEVEL_OF_CARE_H]
			(ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT ID, ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO

CREATE TRIGGER [dbo].[utg_Admission_Level_Of_Care_InsteadOfInsert] 
   ON  [dbo].[ADMISSION_LEVEL_OF_CARE]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')     
		INSERT INTO [dbo].[ADMISSION_LEVEL_OF_CARE]
			(ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	ELSE
		INSERT INTO [dbo].[ADMISSION_LEVEL_OF_CARE]
			(ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, _ssis_timestamp)
		SELECT ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE, _ssis_timestamp
			FROM inserted;
END
GO

CREATE TRIGGER [dbo].[utg_Admission_Level_Of_Care_InsteadOfUpdate] 
   ON  [dbo].[ADMISSION_LEVEL_OF_CARE] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

	IF (UPPER(@AUDIT_VALUE) = 'Y')
 		UPDATE [dbo].[ADMISSION_LEVEL_OF_CARE]
		SET ADMISSION_ID = inserted.ADMISSION_ID, 
			CREATION_DATE = inserted.CREATION_DATE,
			LEVEL_OF_CARE = inserted.LEVEL_OF_CARE,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[ADMISSION_LEVEL_OF_CARE]
			INNER JOIN inserted ON inserted.ID = [dbo].[ADMISSION_LEVEL_OF_CARE].ID;	
	 ELSE
		UPDATE [dbo].[ADMISSION_LEVEL_OF_CARE]
		SET ADMISSION_ID = inserted.ADMISSION_ID, 
			CREATION_DATE = inserted.CREATION_DATE,
			LEVEL_OF_CARE = inserted.LEVEL_OF_CARE,
			_ssis_timestamp = current_timestamp			
		FROM [dbo].[ADMISSION_LEVEL_OF_CARE]
			INNER JOIN inserted ON inserted.ID = [dbo].[ADMISSION_LEVEL_OF_CARE].ID;
END
GO

-- Constraints
ALTER TABLE [dbo].[ADMISSION_LEVEL_OF_CARE] ADD CONSTRAINT [PK_ADMISSION_LEVEL_OF_CARE] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[ADMISSION_LEVEL_OF_CARE] ADD CONSTRAINT [FK_ADMISSION_LEVEL_OF_CARE_ADMISSION_EVN] FOREIGN KEY ([ADMISSION_ID]) REFERENCES [dbo].[ADMISSION_EVN] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_ADMISSION_ID] ON [dbo].[ADMISSION_LEVEL_OF_CARE] 
(
	[ADMISSION_ID] ASC
)
INCLUDE ( [LEVEL_OF_CARE],
[CREATION_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The admission event id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'ADMISSION_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The level of care text column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'LEVEL_OF_CARE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and tine when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'CREATION_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores the levels of care of an admission.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who created the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who updated the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_LEVEL_OF_CARE', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO