CREATE TABLE [dbo].[ADMISSION_EVN]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[BED_UID] [UNIQUEIDENTIFIER] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[INITIAL_BED_UID] [UNIQUEIDENTIFIER] NULL,
[INITIAL_WARD_UID] [UNIQUEIDENTIFIER] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[ATND_NURSE_UID] [UNIQUEIDENTIFIER] NULL,
[ADMISSION_DATE] [datetime] NULL,
[ENTERED_BY_UID] [UNIQUEIDENTIFIER] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[HAS_DISCHARGE] [BIT] NOT NULL CONSTRAINT [DF_ADMISSION_EVN_HAS_DISCHARGE] DEFAULT ((0)),
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__ADMISSION___ssis__0CFADF99] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
)
GO
-- Triggers

create trigger [dbo].[ADMISSION_EVN_tgg_ssis_delete] on dbo.ADMISSION_EVN after delete as begin  delete [dbo].[ADMISSION_EVN_ssisdel] from [deleted] _xyz where [dbo].[ADMISSION_EVN_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ADMISSION_EVN_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
create trigger [dbo].[ADMISSION_EVN_tgg_ssis_insert] on dbo.ADMISSION_EVN after insert as begin delete [dbo].[ADMISSION_EVN_ssisdel]  from [inserted] _xyz where [dbo].[ADMISSION_EVN_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE TRIGGER [dbo].[utg_Admission_Evn_AfterDelete] 
   ON  [dbo].[ADMISSION_EVN] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT  ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;

END
GO
CREATE TRIGGER [dbo].[utg_Admission_Evn_AfterInsert] 
   ON  [dbo].[ADMISSION_EVN] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Admission_Evn_AfterUpdate] 
   ON  [dbo].[ADMISSION_EVN] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 BEGIN
	   INSERT INTO $(varBMS_HISTORY).[dbo].[Admission_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 END		

END
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[utg_Admission_Evn_InsteadOfInsert] 
   ON  [dbo].[ADMISSION_EVN]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Admission_Evn]
			   (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, CREATED, CREATEDBY)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;

	ELSE
		INSERT INTO [dbo].[Admission_Evn]
			   (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID, VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE
			  FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Admission_Evn_InsteadOfUpdate] 
   ON  [dbo].[ADMISSION_EVN] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Admission_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			BED_UID = inserted.BED_UID,
			WARD_UID = inserted.WARD_UID,
			INITIAL_BED_UID = inserted.INITIAL_BED_UID,  
			INITIAL_WARD_UID = inserted.INITIAL_WARD_UID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			ATND_NURSE_UID = inserted.ATND_NURSE_UID,
			ADMISSION_DATE = inserted.ADMISSION_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			HAS_DISCHARGE = inserted.HAS_DISCHARGE, 
			_ssis_timestamp = current_timestamp,
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Admission_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Admission_Evn].id;
	 ELSE
	    UPDATE [dbo].[Admission_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			BED_UID = inserted.BED_UID,
			WARD_UID = inserted.WARD_UID,
			INITIAL_BED_UID = inserted.INITIAL_BED_UID,  
			INITIAL_WARD_UID = inserted.INITIAL_WARD_UID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			ATND_NURSE_UID = inserted.ATND_NURSE_UID,
			ADMISSION_DATE = inserted.ADMISSION_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			HAS_DISCHARGE = inserted.HAS_DISCHARGE, 
			_ssis_timestamp = current_timestamp,
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE
		FROM [dbo].[Admission_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Admission_Evn].id;

END
GO

-- Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[ADMISSION_EVN] ([_ssis_timestamp])
GO
CREATE NONCLUSTERED INDEX [UX_ADMISSION_EVN_BED_UID_ADMISSION_DATE] ON [dbo].[ADMISSION_EVN] ([BED_UID], [ADMISSION_DATE]) INCLUDE ([ID], [WARD_UID])
GO
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_ADM_DATE] ON [dbo].[ADMISSION_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[ADMISSION_DATE] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_ACT_BED] ON [dbo].[ADMISSION_EVN] 
(
	[BED_UID] ASC,
	[WARD_UID] ASC
)
INCLUDE ( [ADMISSION_DATE],
[ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_ID_BED_UID] ON [dbo].[ADMISSION_EVN] 
(
	[ID] ASC,
	[BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_PATIENT_UID] ON [dbo].[ADMISSION_EVN] 
([PATIENT_UID])
GO

CREATE NONCLUSTERED INDEX [IDX_WARD_UID_ENTERED_DATE_ADMISSION_DATE] ON [dbo].[ADMISSION_EVN] 
(
	[WARD_UID] ASC,
	[ENTERED_DATE] ASC,
	[ADMISSION_DATE] ASC
)
INCLUDE ( [CREATION_UTC_DATE]) 
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_BED_PATIENT_WARD] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[BED_UID] ASC,
	[PATIENT_UID] ASC,
	[WARD_UID] ASC
)
INCLUDE ( [IEN]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_VISTA_SITE_UID] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [ID],
[BED_UID],
[ADMISSION_DATE],
[DOMAIN_ID]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_FILTERED_ACTIVE_ADMISSION_BY_WARD_UID] ON [dbo].[ADMISSION_EVN] 
(
	[HAS_DISCHARGE] ASC,
	[WARD_UID] ASC
)
INCLUDE ( [ID],
[BED_UID],
[ADMISSION_DATE],
[DOMAIN_ID]) 
WHERE ([HAS_DISCHARGE]=(0))
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_ADM_DATE_WITH_INCLUDE] ON [dbo].[ADMISSION_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[ADMISSION_DATE] ASC
)
INCLUDE ( [ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID])
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE INDEX IDX_INITIAL_BED_UID_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([INITIAL_BED_UID], [VISTA_SITE_UID],[ADMISSION_DATE]) 
INCLUDE ([ID], [IEN], [INITIAL_WARD_UID])    
GO

CREATE INDEX IDX_VISTA_SITE_UID_HAS_DISCHARGEWITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([VISTA_SITE_UID], [HAS_DISCHARGE]) 
INCLUDE ([ID], [DOMAIN_ID], [IEN], [PATIENT_UID], [ENTERED_DATE], [BED_UID], [WARD_UID], [ADMISSION_DATE]) 
GO

CREATE INDEX IDX_VISTA_SITE_UID_HAS_DISCHARGE_WARD_UID_WITH_INCLUDE ON [dbo].[ADMISSION_EVN] ([VISTA_SITE_UID], [HAS_DISCHARGE],[WARD_UID]) 
INCLUDE ([PATIENT_UID])       
GO

-- Constraints
ALTER TABLE [dbo].[ADMISSION_EVN] ADD CONSTRAINT [PK_ADMISSION_EVN] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[ADMISSION_EVN] ADD CONSTRAINT [FK_ADMISSION_EVN_CONCEPT_TYPE_OF_MOVEMENT] FOREIGN KEY ([TYPE_OF_MOVEMENT_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[ADMISSION_EVN] ADD CONSTRAINT [DF_ADMISSION_EVN_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO
-- Extended Properties
EXEC sp_addextendedproperty N'MS_Description', N'Admission event table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'ADMISSION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Medical personnel''s id.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'ATND_NURSE_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of bed where the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the person who made the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the type of the admission(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the ward where the patient was admitted.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of admissions.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates if patient is discharged.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'HAS_DISCHARGE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_EVN', 'COLUMN', N'ENTERED_DATE'
GO