﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Facade;
using System.Web.Mvc;
using System.Text;
using InfoWorld.EVS.CTSMAPI;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Unavailable Reason View Model class.
    /// </summary>
    public class UnavailableReasonViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the unavailable reason text.
        /// </summary>
        /// <value>
        /// The unavailable reason text.
        /// </value>
        [ValidateXss]
        public string UnavailableReasonText { get; set; }
        /// <summary>
        /// Gets or sets the type code of the unavailable reason.
        /// </summary>
        /// <value>
        /// The type code of the unavailable reason.
        /// </value>
        public string UnavailableReasonType { get; set; }
        /// <summary>
        /// Gets or sets the unavailable reason type text.
        /// </summary>
        /// <value>
        /// The unavailable reason type text.
        /// </value>
        public string UnavailableReasonTypeText { get; set; }
        /// <summary>
        /// Gets or sets the unavailable reason type list.
        /// </summary>
        /// <value>
        /// The unavailable reason type list.
        /// </value>
        public CDList UnavailableReasonTypeList { get; set; }
        /// <summary>
        /// Sets the unavailable reason list.
        /// </summary>
        /// <value>
        /// The unavailable reason list.
        /// </value>
        public IList<CDWithProperties> UnavailableReasonList
        {
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    UnavailableReasonListExtended = new List<UnavailableReasonItemViewModel>();
                    string _reasonText = string.Empty;
                    // generate the extended unavailable reason list(with the type text property).
                    if (value != null)
                    {
                        //foreach (CodeFilterParametersWithProperty item in value)
                        foreach (CDWithProperties item in value)
                        {
                            _reasonText = UnavailableReasonTypeList.SingleOrDefault(cp => cp.code == item.Properties.SingleOrDefault(a => a.PropertyName.text == "Type").PropertyValue.text).displayName;
                            UnavailableReasonListExtended.Add(new UnavailableReasonItemViewModel() { Model = item, ReasonType = _reasonText });
                        }
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        /// <summary>
        /// Gets or sets the unavailable reason list extended(contains an additional propertyfor the type text column).
        /// </summary>
        /// <value>
        /// The unavailable reason list extended.
        /// </value>
        public IList<UnavailableReasonItemViewModel> UnavailableReasonListExtended { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the display button when missing reason text.
        /// </summary>
        /// <value>
        /// The display button when missing reason text.
        /// </value>
        public string DisplayButtonWhenMissingReasonText { get; set; }

        /// <summary>
        /// Gets or sets the display button when successfully edit reason text.
        /// </summary>
        /// <value>
        /// The display button when successfully edit reason text.
        /// </value>
        public string DisplayButtonWhenSuccessfullyEditReasonText { get; set; }

        /// <summary>
        /// Gets or sets the unavailable reason code.
        /// </summary>
        /// <value>
        /// The unavailable reason code.
        /// </value>
        public string UnavailableReasonCode { get; set; }
    }

    /// <summary>
    /// Additional view model class containing unavailable reason object and the type text.
    /// </summary>
    public class UnavailableReasonItemViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the unavailable reason object.
        /// </summary>
        /// <value>
        /// The unavailable reason object.
        /// </value>
        public CDWithProperties Model { get; set; }
        /// <summary>
        /// Gets or sets the type text of the reason.
        /// </summary>
        /// <value>
        /// The type text of the reason.
        /// </value>
        public string ReasonType { get; set; }
    }
}