﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Web.Mvc;
using System.Web.Security;
using BMS.Facade.Data;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model used for the login view.
    /// </summary>
    public class LogOnModel
    {
        /// <summary>
        /// User name.
        /// </summary>
        [Required]
        [Display(Name = "User name")]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the full name of the user.
        /// </summary>
        /// <value>
        /// The full name of the user.
        /// </value>
        public string FullUserName { get; set; }

        /// <summary>
        /// Password.
        /// </summary>
        [Required]
        [DataType(DataType.Password)]
        [Display(Name = "Password")]
        public string Password { get; set; }

        /// <summary>
        /// Whether to create a persistent cookie 
        /// (one that is saved across browser sessions).
        /// </summary>
        [Display(Name = "Remember me?")]
        public bool RememberMe { get; set; }
    }

}
