﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.Web.App_GlobalResource;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// EmsBedStatusAdmin View Model class.
    /// </summary>
    public class EmsBedStatusAdminViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the last update.
        /// </summary>
        /// <value>
        /// The last update.
        /// </value>
        public DateTime LastUpdate { get; set; }

        /// <summary>
        /// Gets or sets the facility site time zone.
        /// </summary>
        /// <value>
        /// The facility site time zone.
        /// </value>
        public string FacilitySiteCodeTimeZone { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        public string Division { get; set; }

        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        public IEnumerable<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the division selected.
        /// </summary>
        /// <value>
        /// The division selected.
        /// </value>
        public Division DivisionSelected { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>

        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the hour of the diversion start date.
        /// </summary>
        /// <value>
        /// The hour of the diversion start date.
        /// </value>
        public string HourStartDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the minutes of the diversion start date.
        /// </summary>
        /// <value>
        /// The minutes of the diversion start date.
        /// </value>
        public string MinuteStartDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the second start date selected.
        /// </summary>
        /// <value>
        /// The second start date selected.
        /// </value>
        public string SecondStartDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the start date string.
        /// </summary>
        /// <value>
        /// The start date string.
        /// </value>
        [Required(ErrorMessage = "Start Date required")]
        public string StartDateString
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return StartDate.ToString(Strings.USDate);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    StartDate = DateTime.Parse(value);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the hour of diversion end date selected.
        /// </summary>
        /// <value>
        /// The hour of diversion end date selected.
        /// </value>
        public string HourEndDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the minutes of diversion end date selected.
        /// </summary>
        /// <value>
        /// The minutes of diversion end date selected.
        /// </value>
        public string MinuteEndDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the second end date selected.
        /// </summary>
        /// <value>
        /// The second end date selected.
        /// </value>
        public string SecondEndDateSelected { get; set; }

        /// <summary>
        /// Gets or sets the end date string.
        /// </summary>
        /// <value>
        /// The end date string.
        /// </value>
        [Required(ErrorMessage = "End Date required")]
        public string EndDateString
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return EndDate.ToString(Strings.USDate);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    EndDate = DateTime.Parse(value);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is EMS module active.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is EMS module active; otherwise, <c>false</c>.
        /// </value>
        public bool IsEMSModuleActive { get; set; }


        private IList<BedCleanInfo> _bedCleanInfoList;
        /// <summary>
        /// Gets or sets the bed clean info list.
        /// </summary>
        /// <value>
        /// The bed clean info list.
        /// </value>
        public IList<BedCleanInfo> BedCleanInfoList 
        {
            get { return _bedCleanInfoList; }
            set 
            {
                _bedCleanInfoList = value;
                BedCleanInfoListExtended = new List<BedCleanInfoCheck>();
                foreach (BedCleanInfo bci in _bedCleanInfoList)                
                    BedCleanInfoListExtended.Add(new BedCleanInfoCheck() { Item = bci, IsChecked = false });                
            } 
        }

        public IList<BedCleanInfoCheck> BedCleanInfoListExtended { get; set; }

        public string BtnBatchAssign { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [previous loaded].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [previous loaded]; otherwise, <c>false</c>.
        /// </value>
        public bool PreviousLoaded { get; set; }

        /// <summary>
        /// Gets or sets the bed clean.
        /// </summary>
        /// <value>
        /// The bed clean.
        /// </value>
        public BedClean BedClean { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed.
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the user name of the application.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the accepted by.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        [ValidateXss]
        public string AcceptedBy { get; set; }

        /// <summary>
        /// Gets or sets the completed by.
        /// </summary>
        /// <value>
        /// The completed by.
        /// </value>
        [ValidateXss]
        public string CompletedBy { get; set; }

        /// <summary>
        /// Gets or sets the completed date.
        /// </summary>
        /// <value>
        /// The completed date.
        /// </value>
        public string CompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the completed time.
        /// </summary>
        /// <value>
        /// The completed time.
        /// </value>
        public string CompletedTime { get; set; }

        /// <summary>
        /// Gets or sets the edit date time.
        /// </summary>
        /// <value>
        /// The edit date time.
        /// </value>
        public DateTime EditDateTime { get; set; }

        /// <summary>
        /// Gets or sets the edit date.
        /// </summary>
        /// <value>
        /// The edit date.
        /// </value>
        public string EditDate { get; set; }

        /// <summary>
        /// Gets or sets the edit time.
        /// </summary>
        /// <value>
        /// The edit time.
        /// </value>
        public string EditTime { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has accepted by value.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has accepted by value; otherwise, <c>false</c>.
        /// </value>
        public bool HasAcceptedByValue { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has completed by value.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has completed by value; otherwise, <c>false</c>.
        /// </value>
        public bool HasCompletedByValue { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the domain.
        /// </summary>
        /// <value>
        /// The domain.
        /// </value>
        public string Domain { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has accepted by completed by value.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has accepted by completed by value; otherwise, <c>false</c>.
        /// </value>
        public bool HasAcceptedByCompletedByValue { get; set; }

        /// <summary>
        /// Gets or sets the display last edit date.
        /// </summary>
        /// <value>
        /// The display last edit date.
        /// </value>
        public string DisplayLastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the EMS report division id.
        /// </summary>
        /// <value>
        /// The EMS report division id.
        /// </value>
        public string EMSReportDivisionId { get; set; }

        /// <summary>
        /// Gets or sets the return link URL.
        /// </summary>
        /// <value>
        /// The return link URL.
        /// </value>
        public string ReturnLinkUrl { get; set; }

        /// <summary>
        /// Gets or sets the special instructions.
        /// </summary>
        /// <value>
        /// The special instructions.
        /// </value>
        public string SpecialInstructions { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [ValidateXss]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the submit button.
        /// </summary>
        /// <value>
        /// The submit button.
        /// </value>
        public string SubmitButton { get; set; }

        /// <summary>
        /// Gets or sets the comment button.
        /// </summary>
        /// <value>
        /// The comment button.
        /// </value>
        public string CommentButton { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the comment button was pressed.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if comment button was pressed; otherwise, <c>false</c>.
        /// </value>
        public bool IsCommentButtonPressed { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [user has EMS supervisor permission].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [user has EMS supervisor permission]; otherwise, <c>false</c>.
        /// </value>
        public bool UserHasEMSSupervisorPermission { get; set; }

        /// <summary>
        /// Gets or sets the EMS user list.
        /// </summary>
        /// <value>
        /// The EMS user list.
        /// </value>
        public List<string> EMSUserList { get; set; }

        /// <summary>
        /// Gets or sets the selected EMS user.
        /// </summary>
        /// <value>
        /// The selected EMS user.
        /// </value>
        [Required(ErrorMessage = "Assigned To field is required!")]
        [ValidateXss]
        public string SelectedEMSUser { get; set; }

        /// <summary>
        /// Gets or sets the bed clean list selected.
        /// </summary>
        /// <value>
        /// The bed clean list selected.
        /// </value>
        public List<BedCleanInfo> BedCleanListSelected { get; set; }
    }

    public class BedCleanInfoCheck
    {
        public BedCleanInfo Item { get; set; }

        public bool IsChecked { get; set; }
    }
}