﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using System.ComponentModel.DataAnnotations;

namespace BMS.Web.Models
{
    /// <summary>
    /// DischargeClinic ViewModel.
    /// </summary>
    public class DischargeClinicViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the hospital locations.
        /// </summary>
        /// <value>
        /// The hospital locations.
        /// </value>
        public List<HospitalLocation> HospitalLocations { get; set; }

        /// <summary>
        /// Gets or sets the discharge clinics.
        /// </summary>
        /// <value>
        /// The discharge clinics.
        /// </value>
        public List<DischargeClinic> DischargeClinics { get; set; }

        /// <summary>
        /// Gets or sets the discharge clinic extension.
        /// </summary>
        /// <value>
        /// The discharge clinic extension.
        /// </value>
        [Required(ErrorMessage = "You must select a Discharge Clinic Location")]
        public string DischargeClinicExtension { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the first message.
        /// </summary>
        /// <value>
        /// The first message.
        /// </value>
        public string FirstMessage { get; set; }

        /// <summary>
        /// Gets or sets the second message.
        /// </summary>
        /// <value>
        /// The second message.
        /// </value>
        public string SecondMessage { get; set; }

        /// <summary>
        /// Gets or sets the button save.
        /// </summary>
        /// <value>
        /// The button save.
        /// </value>
        public string ButtonSave { get; set; }

        /// <summary>
        /// Gets or sets the button load HL.
        /// </summary>
        /// <value>
        /// The button load HL.
        /// </value>
        public string ButtonLoadHL { get; set; }
    }
}
