﻿using System;
using System.Web.Util;
using System.IO;
using Microsoft.Security.Application;

namespace BMS.Web.Controllers.Shared
{
    public class AntiXssEncoder : HttpEncoder
    {
        public AntiXssEncoder() { }

        protected override void HtmlEncode(string value, TextWriter output)
        {
            output.Write(Encoder.HtmlEncode(value));
        }

        protected override void HtmlAttributeEncode(string value, TextWriter output)
        {
            output.Write(Encoder.HtmlAttributeEncode(value));
        }

        protected override void HtmlDecode(string value, TextWriter output)
        {
            base.HtmlDecode(value, output);
        }

        public string Encode(string value)
        {
            return Encoder.HtmlEncode(value);
        }

        public string Decode(string value)
        {
            if (string.IsNullOrEmpty(value)) return value;
            TextWriter writer = new StringWriter();
            if (string.Compare(value.ToUpper(), value, false) == 0)
            {
                // is uppercase
                this.HtmlDecode(value.ToLower(), writer);
                return writer.ToString().ToUpper();
            }
            else
            {
                this.HtmlDecode(value, writer);
                return writer.ToString();
            }
        }        
    }
}