﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using Microsoft.Web.Mvc;
using BMS.Utils;
using BMS.Web.Controllers.Shared;
using System.Text;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class MaintainMarqueeController : BaseController
    {
        /// <summary>
        /// Default action for the MaintainMarquee controller.
        /// </summary>
        /// <returns>Index view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MaintainMarqueeModel model = new MaintainMarqueeModel();
                AntiXssEncoder xss = new AntiXssEncoder();
                model.MarqueeText = xss.Decode(FacadeManager.ConfigurationInterface.GetMarquee(this.loggedUser.Domain));
                model.MarqueeText = HtmlSanitizerUtility.Instance.CssDecode(model.MarqueeText);
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(MaintainMarqueeModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction<MaintainMarqueeController>(act => act.Index());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Changes the marquee text.
        /// </summary>
        /// <param name="model">Model.</param>
        /// <returns></returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult ChangeMarquee(MaintainMarqueeModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                HtmlSanitizerUtility htmlSanitizerUtility = HtmlSanitizerUtility.Instance;
                string marquee = htmlSanitizerUtility.SanitizeHtml(model.MarqueeText);
                FacadeManager.ConfigurationInterface.SaveMarquee(marquee, this.loggedUser.Domain);
                model.MarqueeText = htmlSanitizerUtility.CssDecode(marquee);
                model.LoggedUser = loggedUser;
                return View("Saved", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
