﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Utils;
using BMS.Facade.Data;
using BMS.Facade;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// Icon Legend Controller class.
    /// </summary>
    public class IconLegendController : BaseController
    {
        /// <summary>
        /// Default action for the Icon Legend Controller.
        /// </summary>
        /// <returns>Returns the Icon Legend view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconLegendViewModel model = new IconLegendViewModel();
                List<IconInfo> icons = FacadeManager.IconInterface.GetAllIconsByFacility(Guid.Parse(this.loggedUser.Facility.Id.extension));
                if (icons != null && icons.Count > 0)
                {
                    model.SystemIconList = icons.Where(a => a.Group.Equals(Constants.APPLICATION_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.SYSTEM_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.SystemIconList = (from p in model.SystemIconList
                                            orderby p.OrderIndex
                                            select p).ToList();
                    model.BedCleaningIconList = icons.Where(a => a.Group.Equals(Constants.APPLICATION_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.BED_CLEANING_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.BedCleaningIconList = (from p in model.BedCleaningIconList
                                            orderby p.OrderIndex
                                            select p).ToList();
                    model.StandardIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.STANDARD_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.StandardIconList = (from p in model.StandardIconList
                                                 orderby p.OrderIndex
                                                 select p).ToList();
                    model.EmergencyIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.EMERGENCY_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.EmergencyIconList = (from p in model.EmergencyIconList
                                              orderby p.OrderIndex
                                              select p).ToList();
                    model.SiteConfigurableIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.SITE_CONFIGURABLE_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.SiteConfigurableIconList = (from p in model.SiteConfigurableIconList
                                               orderby p.OrderIndex
                                               select p).ToList();
                    model.PatientIcon = model.SystemIconList.Where(a => a.IconType.code.Equals(Constants.PATIENT_ICON_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    model.RoomBedIcon = model.SystemIconList.Where(a => a.IconType.code.Equals(Constants.ROOM_BED_ICON_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                }
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
