﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Utils;
using BMS.Facade.Fault;
using BMS.FaultContracts;
using System.ServiceModel;
using System.Text;

namespace BMS.Web.Controllers
{
    public class ExceptionController : Controller
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BaseFacadeException baseFacadeException = TempData.Get<BaseFacadeException>();
                Exception exception = new Exception();
                StringBuilder sb = new StringBuilder();
                if ((baseFacadeException.InnerException as FaultException<GenericWFServiceFault>) != null)
                {
                    FaultException<GenericWFServiceFault> ex = baseFacadeException.InnerException as FaultException<GenericWFServiceFault>;
                    FaultException<object> fault = new FaultException<object>(ex.Detail.ServiceFault);
                    exception = fault;
                }
                else
                    exception = baseFacadeException.InnerException;
                TempData.Put<BaseFacadeException>(baseFacadeException);

                if (((exception as FaultException<CustomSQLException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as CustomSQLException) != null))
                {
                    FaultException<CustomSQLException> ex = exception as FaultException<CustomSQLException>;
                    if (ex == null)
                    {
                        CustomSQLException tempEx = (exception as FaultException<object>).Detail as CustomSQLException;
                        ex = new FaultException<CustomSQLException>(tempEx);
                    }
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Detail.ErrorMessage);
                    sb.Append("Stored procedure: ");
                    sb.AppendLine(ex.Detail.SPName);
                    sb.Append("Line number: ");
                    sb.AppendLine(ex.Detail.LineNumber.ToString());
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<ConfigValueException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as ConfigValueException) != null))
                {
                    FaultException<ConfigValueException> ex = exception as FaultException<ConfigValueException>;
                    if (ex == null)
                    {
                        ConfigValueException tempEx = (exception as FaultException<object>).Detail as ConfigValueException;
                        ex = new FaultException<ConfigValueException>(tempEx);
                    }
                    sb.Append("Key: ");
                    sb.AppendLine(ex.Detail.Key);
                    sb.Append("User name: ");
                    sb.AppendLine(ex.Detail.UserName);
                    sb.Append("Section: ");
                    sb.AppendLine(ex.Detail.Section);
                    sb.Append("Message: ");
                    sb.AppendLine(ex.Detail.Message);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<DefaultConfigException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as DefaultConfigException) != null))
                {
                    FaultException<DefaultConfigException> ex = exception as FaultException<DefaultConfigException>;
                    if (ex == null)
                    {
                        DefaultConfigException tempEx = (exception as FaultException<object>).Detail as DefaultConfigException;
                        ex = new FaultException<DefaultConfigException>(tempEx);
                    }
                    sb.Append("User name: ");
                    sb.AppendLine(ex.Detail.UserName);
                    sb.Append("Message: ");
                    sb.AppendLine(ex.Detail.Message);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<EntityNotFoundException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as EntityNotFoundException) != null))
                {
                    FaultException<EntityNotFoundException> ex = exception as FaultException<EntityNotFoundException>;
                    if (ex == null)
                    {
                        EntityNotFoundException tempEx = (exception as FaultException<object>).Detail as EntityNotFoundException;
                        ex = new FaultException<EntityNotFoundException>(tempEx);
                    }
                    sb.Append("Method type: ");
                    sb.AppendLine(ex.Detail.MethodType.ToString());
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Detail.ErrorMessage);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<NullParameterException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as NullParameterException) != null))
                {
                    FaultException<NullParameterException> ex = exception as FaultException<NullParameterException>;
                    if (ex == null)
                    {
                        NullParameterException tempEx = (exception as FaultException<object>).Detail as NullParameterException;
                        ex = new FaultException<NullParameterException>(tempEx);
                    }
                    sb.Append("Parameter name: ");
                    sb.AppendLine(ex.Detail.ParameterName);
                    sb.Append("Method type: ");
                    sb.AppendLine(ex.Detail.MethodType.ToString());
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Detail.ErrorMessage);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<OtherException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as OtherException) != null))
                {
                    FaultException<OtherException> ex = exception as FaultException<OtherException>;
                    if (ex == null)
                    {
                        OtherException tempEx = (exception as FaultException<object>).Detail as OtherException;
                        ex = new FaultException<OtherException>(tempEx);
                    }
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Detail.ErrorMessage);
                    sb.Append("Stack trace: ");
                    sb.AppendLine(ex.Detail.StackTrace);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (exception as FaultException<GenericException> != null)
                {
                    FaultException<GenericException> ex = exception as FaultException<GenericException>;
                    sb.Append(ex.Detail.FriendlyMessage);
                    return View(new BaseFacadeException(sb.ToString()));
                }
                if (((exception as FaultException<WfOtherException>) != null) || ((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as WfOtherException) != null))
                {
                    FaultException<WfOtherException> ex = exception as FaultException<WfOtherException>;
                    if (ex == null)
                    {
                        WfOtherException tempEx = (exception as FaultException<object>).Detail as WfOtherException;
                        ex = new FaultException<WfOtherException>(tempEx);
                    }
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Detail.ErrorMessage);
                    sb.Append("Stack trace: ");
                    sb.AppendLine(ex.Detail.StackTrace);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }
                if (((exception as FaultException<object>) != null && ((exception as FaultException<object>).Detail as WFInvalidOperation) != null))
                {
                    WFInvalidOperation tempEx = (exception as FaultException<object>).Detail as WFInvalidOperation;
                    FaultException<WFInvalidOperation> ex = new FaultException<WFInvalidOperation>(tempEx);
                    sb.Append(@"<h4 style=""display:inline;"">");
                    sb.Append(ex.Detail.FriendlyMessage);
                    sb.AppendLine("</h4>");
                    sb.AppendLine();
                    //if (!string.IsNullOrEmpty(ex.Detail.SourceStateName))
                    //{
                    //    sb.Append("Source State: ");
                    //    sb.Append("<b>");
                    //    sb.Append(ex.Detail.SourceStateName);
                    //    sb.AppendLine("</b>");
                    //    sb.AppendLine();
                    //}
                    //sb.Append("Operation: ");
                    //sb.Append("<b>");
                    //sb.Append(ex.Detail.OperationName);
                    //sb.AppendLine("</b>");
                    //sb.AppendLine();
                    //sb.AppendLine(@"<a href=""javascript:ShowHideErrorMessage();"">Error message</a> ");
                    //sb.Append(@"<label id=""lblErrorMessage"" style=""display:none;"" >");
                    //sb.Append(ex.Detail.ErrorMessage);
                    //sb.AppendLine(@"</label>");
                    //sb.AppendLine(@"<a href=""javascript:ShowHideStackTrace();"">Stack trace</a> ");
                    //sb.Append(@"<label id=""lblStackTrace"" style=""display:none;"" >");
                    //sb.Append(ex.Detail.StackTrace);
                    //sb.Append(@"</label>");
                    return View("WFException", new BaseFacadeException(sb.ToString(), ex));
                }
                if ((exception as FaultException<object>) != null)
                {
                    FaultException<object> ex = exception as FaultException<object>;
                    sb.Append("Error message: ");
                    sb.AppendLine(ex.Message);
                    sb.Append("Stack trace: ");
                    sb.AppendLine(ex.StackTrace);
                    return View(new BaseFacadeException(sb.ToString(), ex));
                }                
                return View(baseFacadeException);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
