﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using Microsoft.Web.Mvc;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.Utils.Properties;
using BMS.Web.App_GlobalResource;
using BMS.ServicesWrapper.BMService;
using BMS.Facade.Translators;
using BMS.ServicesWrapper.Security;
using System.Text;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// EmsBedStatusAdmin Controller class.
    /// </summary>
    [ValidateInput(false)]
    public class EmsBedStatusAdminController : BaseController
    {
        /// <summary>
        /// Default action for the EmsBedStatusAdmin controller.
        /// </summary>
        /// <returns>Index view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ModelState.Clear();
                EmsBedStatusAdminViewModel mainViewModel = new EmsBedStatusAdminViewModel();
                //gets status of EMS Module
                mainViewModel.IsEMSModuleActive = FacadeManager.ConfigurationInterface.GetModules(this.loggedUser.Domain, this.loggedUser.Facility.Id).Where(module => module.Code == Constants.EMS_MODULE).Select(module => { if (module.CurrentlyInUse.displayName == Constants.Yes) return true; else return false; }).FirstOrDefault();
                //gets LastUpdate                                                                                      
                mainViewModel.LastUpdate = DateTimeNowOnCurrentFacility;
                TimeZoneInfo tzi = TimeZoneInfoOnCurrentFacility;
                if (tzi != null)
                {
                    try
                    {
                        mainViewModel.FacilitySiteCodeTimeZone = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.TimeZone).Where(a => a.displayName.Equals(tzi.Id)).FirstOrDefault().code;
                    }
                    catch 
                    {
                        FacilitySettings facilitySettings = FacadeManager.ConfigurationInterface.GetFacilitySettings(this.loggedUser.Facility.Id);
                        if (facilitySettings != null && facilitySettings.FacilitySiteTimeZone != null)
                            mainViewModel.FacilitySiteCodeTimeZone = facilitySettings.FacilitySiteTimeZone.code;
                    }
                }

                //gets list of divisions
                mainViewModel.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id);

                //Add All Wards option to the drop down list.
                mainViewModel.DivisionList = GetDefaultDivison().Concat(mainViewModel.DivisionList);
                //gets Division selected 
                mainViewModel.DivisionSelected = GetDivisionSelected(mainViewModel, QueryStrings["division"]);

                DateTime date;
                if (string.IsNullOrEmpty(QueryStrings["startDate"]) || !DateTime.TryParse(QueryStrings["startDate"], out date))
                {
                    mainViewModel.StartDate = new DateTime(DateTimeNowOnCurrentFacility.Year, DateTimeNowOnCurrentFacility.Month,
                                                   DateTimeNowOnCurrentFacility.Day,
                                                   Convert.ToInt32("00"),
                                                   Convert.ToInt32("00"),
                                                   Convert.ToInt32("00"));
                }
                else
                    mainViewModel.StartDate = DateTime.Parse(QueryStrings["startDate"]);
                mainViewModel.HourStartDateSelected = (mainViewModel.StartDate.Hour < 10) ? "0" + mainViewModel.StartDate.Hour.ToString() : mainViewModel.StartDate.Hour.ToString();
                mainViewModel.MinuteStartDateSelected = (mainViewModel.StartDate.Minute < 10) ? "0" + mainViewModel.StartDate.Minute.ToString() : mainViewModel.StartDate.Minute.ToString();
                mainViewModel.SecondStartDateSelected = (mainViewModel.StartDate.Second < 10) ? "0" + mainViewModel.StartDate.Second.ToString() : mainViewModel.StartDate.Second.ToString();


                if (string.IsNullOrEmpty(QueryStrings["endDate"]) || !DateTime.TryParse(QueryStrings["endDate"], out date))
                {
                    mainViewModel.EndDate = new DateTime(DateTimeNowOnCurrentFacility.Year, DateTimeNowOnCurrentFacility.Month,
                                                   DateTimeNowOnCurrentFacility.Day,
                                                   Convert.ToInt32("23"),
                                                   Convert.ToInt32("59"),
                                                   Convert.ToInt32("59"));
                }
                else
                    mainViewModel.EndDate = DateTime.Parse(QueryStrings["endDate"]);
                mainViewModel.HourEndDateSelected = (mainViewModel.EndDate.Hour < 10) ? "0" + mainViewModel.EndDate.Hour.ToString() : mainViewModel.EndDate.Hour.ToString();
                mainViewModel.MinuteEndDateSelected = (mainViewModel.EndDate.Minute < 10) ? "0" + mainViewModel.EndDate.Minute.ToString() : mainViewModel.EndDate.Minute.ToString();
                mainViewModel.SecondEndDateSelected = (mainViewModel.EndDate.Second < 10) ? "0" + mainViewModel.EndDate.Second.ToString() : mainViewModel.EndDate.Second.ToString();

                string wardIdList = string.Empty;
                List<Ward> wards = new List<Ward>();
                if (mainViewModel.DivisionSelected != null && mainViewModel.DivisionSelected.Id != null)
                    wards = FacadeManager.EntityInterface.GetWardsByDivisionId(mainViewModel.DivisionSelected.Id).ToList();
                else
                    wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();
                foreach (Ward ward in wards)
                    wardIdList += ward.Id.extension + ",";

                mainViewModel.BedCleanInfoList = FacadeManager.BedInterface.GetBedsClean(wardIdList, mainViewModel.DivisionSelected.Id, this.loggedUser.Facility.Id, mainViewModel.StartDate, mainViewModel.EndDate, tzi);

                mainViewModel.ReturnLinkUrl = QueryStrings["returnLink"];
                mainViewModel.EMSReportDivisionId = QueryStrings["divisionFromReport"];
                mainViewModel.UserHasEMSSupervisorPermission = FacadeManager.UserInterface.CheckPermission(Constants.EMS_Supervisor_Permission);
                mainViewModel.LoggedUser = loggedUser;

                return View(mainViewModel);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Post action for the EmsBedStatusAdminController.
        /// </summary>
        /// <param name="viewModel">The Ems Bed Status view model.</param>
        /// <returns></returns>
        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(EmsBedStatusAdminViewModel viewModel)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DateTime sDate = GetDate(viewModel.StartDate, viewModel.HourStartDateSelected, viewModel.MinuteStartDateSelected, viewModel.SecondStartDateSelected);
                DateTime eDate = GetDate(viewModel.EndDate, viewModel.HourEndDateSelected, viewModel.MinuteEndDateSelected, viewModel.SecondEndDateSelected);

                if (!string.IsNullOrEmpty(viewModel.BtnBatchAssign))
                {
                    StringBuilder ids = new StringBuilder();
                    foreach (BedCleanInfoCheck chk in viewModel.BedCleanInfoListExtended)
                    {
                        if (chk.IsChecked)
                        {
                            ids.Append(chk.Item.BedCleanId.extension);
                            ids.Append(",");
                        }
                    }
                    return this.RedirectToAction<EmsBedStatusAdminController>(act => act.EMSBatchAssign(EncryptQueryString(new string[] { "ids", "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { ids.ToString(), viewModel.Division, sDate.ToString("G"), eDate.ToString("G"), viewModel.ReturnLinkUrl, viewModel.EMSReportDivisionId }, loggedUser.Salt)));
                }                

                if (eDate < sDate)
                {
                    ModelState.AddModelError("EndDateString", Strings.EndDateMustBeGreaterThanStartDate);
                    //Fill error model
                    FillModelError(viewModel);
                    //display Index view
                    return View("Index", viewModel);
                }

                return this.RedirectToAction<EmsBedStatusAdminController>(act => act.Index(EncryptQueryString(new string[] { "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { viewModel.Division, sDate.ToString("G"), eDate.ToString("G"), viewModel.ReturnLinkUrl, viewModel.EMSReportDivisionId }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Edit bed clean.
        /// </summary>
        /// <param name="id">The id of bed clean.</param>
        /// <param name="domain">The domain.</param>
        /// <returns>Edit view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsBedStatusAdminViewModel viewModel = new EmsBedStatusAdminViewModel();

                viewModel.Division = QueryStrings["division"];
                viewModel.StartDate = DateTime.Parse(QueryStrings["startDate"]);
                viewModel.EndDate = DateTime.Parse(QueryStrings["endDate"]);
                viewModel.EMSReportDivisionId = QueryStrings["divisionFromReport"];
                viewModel.BedClean = FacadeManager.BedInterface.GetBedCleanById(new II { root = loggedUser.Domain, extension = QueryStrings["id"] }, this.loggedUser.Facility.Id);
                viewModel.Id = viewModel.BedClean.Id.extension;
                viewModel.Domain = viewModel.BedClean.Id.root;
                viewModel.BedName = viewModel.BedClean.Bed.Name;
                Ward ward = FacadeManager.EntityInterface.GetWardById(viewModel.BedClean.Ward.Id);
                viewModel.WardName = FacadeManager.EntityInterface.GetDivisionById(ward.Division.Id).Name;
                viewModel.UserName = this.loggedUser.UserName;
                viewModel.EditDateTime = DateTimeNowOnCurrentFacility;
                viewModel.EditDate = viewModel.EditDateTime.ToShortDateString();
                viewModel.EditTime = viewModel.EditDateTime.ToString("HH:mm");
                viewModel.AcceptedBy = viewModel.BedClean.AcceptedBy;
                viewModel.CompletedBy = viewModel.BedClean.CompletedBy;
                viewModel.CompletedDate = viewModel.BedClean.CompletedDate.HasValue ? viewModel.BedClean.CompletedDate.Value.ToShortDateString() : string.Empty;
                viewModel.CompletedTime = viewModel.BedClean.CompletedDate.HasValue ? viewModel.BedClean.CompletedDate.Value.ToString("HH:mm") : string.Empty;
                if (!string.IsNullOrEmpty(viewModel.BedClean.AcceptedBy))
                {
                    viewModel.HasAcceptedByValue = true;
                }
                else
                {
                    viewModel.HasAcceptedByValue = false;
                    viewModel.SelectedEMSUser = viewModel.UserName;
                }
                if (!string.IsNullOrEmpty(viewModel.BedClean.CompletedBy))
                {
                    viewModel.HasCompletedByValue = true;
                }
                else
                {
                    viewModel.HasCompletedByValue = false;
                    if (viewModel.HasAcceptedByValue)
                        viewModel.SelectedEMSUser = viewModel.AcceptedBy;
                }
                viewModel.SpecialInstructions = viewModel.BedClean.SpecialInstructions;
                viewModel.Comment = viewModel.BedClean.Comment;
                viewModel.UserHasEMSSupervisorPermission = FacadeManager.UserInterface.CheckPermission(Constants.EMS_Supervisor_Permission);
                if (viewModel.UserHasEMSSupervisorPermission)
                    viewModel.EMSUserList = GetEMSUsers();
                else
                    viewModel.EMSUserList = new List<string>();
                viewModel.ReturnLinkUrl = QueryStrings["returnLink"];
                viewModel.LoggedUser = loggedUser;
                return View(viewModel);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Edit(EmsBedStatusAdminViewModel viewModel)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                viewModel.IsCommentButtonPressed = false;
                //gets BedClean By Id
                BedClean bedclean = FacadeManager.BedInterface.GetBedCleanById(new II { root = viewModel.Domain, extension = viewModel.Id }, this.loggedUser.Facility.Id);
                bedclean.LastEditedBy = viewModel.UserName;
                bedclean.LastEditDate = new DateTime(Convert.ToDateTime(viewModel.EditDate).Year,
                                                        Convert.ToDateTime(viewModel.EditDate).Month,
                                                        Convert.ToDateTime(viewModel.EditDate).Day,
                                                        Convert.ToInt32(viewModel.EditTime.Substring(0, 2)),
                                                        Convert.ToInt32(viewModel.EditTime.Substring(3, 2)), 0);

                //check if submit button was clicked
                if (!string.IsNullOrEmpty(viewModel.SubmitButton))
                {
                    if (!viewModel.HasAcceptedByValue)
                    {
                        if (FacadeManager.UserInterface.CheckPermission(Constants.EMS_Supervisor_Permission))
                            bedclean.AcceptedBy = viewModel.SelectedEMSUser;
                        else
                            bedclean.AcceptedBy = viewModel.UserName;
                        bedclean.AcceptedDate = new DateTime(Convert.ToDateTime(viewModel.EditDate).Year,
                                                             Convert.ToDateTime(viewModel.EditDate).Month,
                                                             Convert.ToDateTime(viewModel.EditDate).Day,
                                                             Convert.ToInt32(viewModel.EditTime.Substring(0, 2)),
                                                             Convert.ToInt32(viewModel.EditTime.Substring(3, 2)), 0);

                        DateTimeConverter.ConvertDateToUTC(bedclean, loggedUser.Facility.Id);
                        BMSFactory.BedManagerOperationsClient.UpdateBedCleaningOperation(bedclean.ToDataContract());
                    }
                    else
                    {
                        if (FacadeManager.UserInterface.CheckPermission(Constants.EMS_Supervisor_Permission))
                            bedclean.CompletedBy = viewModel.SelectedEMSUser;
                        else
                            bedclean.CompletedBy = viewModel.UserName;
                        bedclean.CompletedDate = new DateTime(Convert.ToDateTime(viewModel.EditDate).Year,
                                                             Convert.ToDateTime(viewModel.EditDate).Month,
                                                             Convert.ToDateTime(viewModel.EditDate).Day,
                                                             Convert.ToInt32(viewModel.EditTime.Substring(0, 2)),
                                                             Convert.ToInt32(viewModel.EditTime.Substring(3, 2)), 0);
                        bedclean.Comment = viewModel.Comment;
                        bedclean.CommentedBy = this.loggedUser.UserName;
                        bedclean.CommentedDate = DateTimeNowOnCurrentFacility;

                        DateTimeConverter.ConvertDateToUTC(bedclean, loggedUser.Facility.Id);
                        BMSFactory.BedManagerOperationsClient.UpdateBedCleaningOperation(bedclean.ToDataContract());
                        FacadeManager.BedInterface.SendCleanDirtyBedNotifications(bedclean);
                    }
                }
                else //comment button was pressed
                {
                    bedclean.Comment = viewModel.Comment;
                    bedclean.CommentedBy = this.loggedUser.UserName;
                    bedclean.CommentedDate = DateTimeNowOnCurrentFacility;
                    viewModel.IsCommentButtonPressed = true;

                    DateTimeConverter.ConvertDateToUTC(bedclean, loggedUser.Facility.Id);
                    BMSFactory.BedManagerOperationsClient.UpdateBedCleaningOperation(bedclean.ToDataContract());
                }

                //display SaveConfirmation view
                return this.RedirectToAction<EmsBedStatusAdminController>(act => act.SaveConfirmation(EncryptQueryString(new string[] { "id", "division", "startDate", "endDate", "returnLink", "isCommentPressed", "divisionFromReport" }, new string[] { viewModel.Id, viewModel.Division, viewModel.StartDate.ToString("G"), viewModel.EndDate.ToString("G"), viewModel.ReturnLinkUrl, viewModel.IsCommentButtonPressed.ToString(), viewModel.EMSReportDivisionId }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Display save confirmation view.
        /// </summary>
        /// <param name="id">Id of bed cleaning.</param>
        /// <param name="domain">The domain.</param>
        /// <returns>Save Confirmation view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult SaveConfirmation(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsBedStatusAdminViewModel viewModel = new EmsBedStatusAdminViewModel();

                viewModel.BedClean = FacadeManager.BedInterface.GetBedCleanById(new II { root = loggedUser.Domain, extension = QueryStrings["id"] }, this.loggedUser.Facility.Id);

                viewModel.Id = viewModel.BedClean.Id.extension;
                viewModel.BedName = viewModel.BedClean.Bed.Name;
                Ward ward = FacadeManager.EntityInterface.GetWardById(viewModel.BedClean.Ward.Id);
                viewModel.WardName = FacadeManager.EntityInterface.GetDivisionById(ward.Division.Id).Name;
                viewModel.AcceptedBy = viewModel.BedClean.AcceptedBy;
                viewModel.CompletedBy = viewModel.BedClean.CompletedBy;
                viewModel.EMSReportDivisionId = QueryStrings["divisionFromReport"];
                viewModel.Division = QueryStrings["division"];
                viewModel.StartDate = DateTime.Parse(QueryStrings["startDate"]);
                viewModel.EndDate = DateTime.Parse(QueryStrings["endDate"]);
                viewModel.IsCommentButtonPressed = bool.Parse(QueryStrings["isCommentPressed"]);
                viewModel.Comment = viewModel.BedClean.Comment;
                viewModel.ReturnLinkUrl = QueryStrings["returnLink"];

                if (!string.IsNullOrEmpty(viewModel.AcceptedBy) && !string.IsNullOrEmpty(viewModel.CompletedBy))
                    viewModel.HasAcceptedByCompletedByValue = true;
                else
                    viewModel.HasAcceptedByCompletedByValue = false;

                if (viewModel.BedClean.LastEditDate.HasValue)
                    viewModel.DisplayLastEditDate = viewModel.BedClean.LastEditDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    viewModel.DisplayLastEditDate = string.Empty;
                viewModel.LoggedUser = loggedUser;
                return View(viewModel);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult EMSBatchAssign(string p)
        {
            EmsBedStatusAdminViewModel model = new EmsBedStatusAdminViewModel();
            model.EMSUserList = GetEMSUsers();
            string wardIdList = string.Empty;
            model.Division = QueryStrings["division"];
            model.StartDate = DateTime.Parse(QueryStrings["startDate"]);
            model.EndDate = DateTime.Parse(QueryStrings["endDate"]);
            model.EditDateTime = DateTimeNowOnCurrentFacility;
            model.EditDate = model.EditDateTime.ToShortDateString();
            model.EditTime = model.EditDateTime.ToString("HH:mm");
            model.EMSReportDivisionId = QueryStrings["divisionFromReport"];
            model.ReturnLinkUrl = QueryStrings["returnLink"];
            List<Ward> wards = new List<Ward>();
            if (!string.IsNullOrEmpty(model.Division))
                wards = FacadeManager.EntityInterface.GetWardsByDivisionId(new II(this.loggedUser.Domain, model.Division)).ToList();
            else
                wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();
            foreach (Ward ward in wards)
                wardIdList += ward.Id.extension + ",";

            string[] bedCleanIds = QueryStrings["ids"].Split(',');
            model.BedCleanListSelected = FacadeManager.BedInterface.GetBedsClean(wardIdList, new II(this.loggedUser.Domain, model.Division), this.loggedUser.Facility.Id, model.StartDate, model.EndDate, TimeZoneInfoOnCurrentFacility).ToList();
            model.BedCleanListSelected = model.BedCleanListSelected.Where(a => bedCleanIds.Contains(a.BedCleanId.extension)).ToList();
            model.LoggedUser = loggedUser;
            return View(model);
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult EMSBatchAssign(EmsBedStatusAdminViewModel input)
        {
            if (input.BedCleanListSelected != null && input.BedCleanListSelected.Count > 0)
            {
                DateTime editDate = new DateTime(Convert.ToDateTime(input.EditDate).Year,
                                            Convert.ToDateTime(input.EditDate).Month,
                                            Convert.ToDateTime(input.EditDate).Day,
                                            Convert.ToInt32(input.EditTime.Substring(0, 2)),
                                            Convert.ToInt32(input.EditTime.Substring(3, 2)), 0);
                AntiXssEncoder xss = new AntiXssEncoder();
                foreach (BedCleanInfo bc in input.BedCleanListSelected)
                {
                    BedClean bedClean = FacadeManager.BedInterface.GetBedCleanById(bc.BedCleanId, this.loggedUser.Facility.Id);
                    bedClean.LastEditedBy = this.loggedUser.UserName;
                    bedClean.LastEditDate = editDate;
                    bedClean.AcceptedBy = xss.Encode(bc.AcceptedBy);
                    bedClean.AcceptedDate = editDate;
                    DateTimeConverter.ConvertDateToUTC(bedClean, this.loggedUser.Facility.Id);
                    BMSFactory.BedManagerOperationsClient.UpdateBedCleaningOperation(bedClean.ToDataContract());
                }
            }
            return this.RedirectToAction<EmsBedStatusAdminController>(act => act.Index(EncryptQueryString(new string[] { "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { input.Division, input.StartDate.ToString("G"), input.EndDate.ToString("G"), input.ReturnLinkUrl, input.EMSReportDivisionId }, loggedUser.Salt)));
        }

        #region Private Methods

        private IEnumerable<Division> GetDefaultDivison()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                yield return new Division { Name = "All Wards", Ien = "-1" };
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Gets the division selected.
        /// </summary>
        /// <param name="viewModel">The view model.</param>
        /// <param name="divisionExtension">The division extension.</param>
        /// <returns>Division.</returns>
        private Division GetDivisionSelected(EmsBedStatusAdminViewModel viewModel, string divisionExtension)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                foreach (Division division in viewModel.DivisionList)
                {
                    if (division.Id != null && division.Id.extension.Equals(divisionExtension, StringComparison.InvariantCultureIgnoreCase))
                    {
                        viewModel.DivisionSelected = division;
                        viewModel.Division = division.Id.extension;
                        return division;
                    }
                }
                return viewModel.DivisionList.First();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Gets the date.
        /// </summary>
        /// <param name="dateTime">The date time.</param>
        /// <param name="hour">The hour.</param>
        /// <param name="minutes">The minutes.</param>
        /// <param name="seconds">The seconds.</param>
        /// <returns>DateTime</returns>
        private DateTime GetDate(DateTime dateTime, string hour, string minutes, string seconds)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return new DateTime(dateTime.Year, dateTime.Month, dateTime.Day, Convert.ToInt32(hour), Convert.ToInt32(minutes), Convert.ToInt32(seconds));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Fills the model error.
        /// </summary>
        /// <param name="viewModel">The view model.</param>
        private void FillModelError(EmsBedStatusAdminViewModel viewModel)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //gets status of EMS Module
                viewModel.IsEMSModuleActive = FacadeManager.ConfigurationInterface.GetModules(this.loggedUser.Domain, this.loggedUser.Facility.Id).Where(module => module.Code == Constants.EMS_MODULE).Select(module => { if (module.CurrentlyInUse.displayName == Constants.Yes) return true; else return false; }).FirstOrDefault();
                //gets LastUpdate                                                                                      
                viewModel.LastUpdate = DateTimeNowOnCurrentFacility;
                FacilitySettings facilitySettings = FacadeManager.ConfigurationInterface.GetFacilitySettings(this.loggedUser.Facility.Id);
                if (facilitySettings != null && facilitySettings.FacilitySiteTimeZone != null)
                    viewModel.FacilitySiteCodeTimeZone = facilitySettings.FacilitySiteTimeZone.code;

                viewModel.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id);

                //Add All Wards option to the drop down list.
                viewModel.DivisionList = GetDefaultDivison().Concat(viewModel.DivisionList);
                viewModel.LoggedUser = loggedUser;
                if (viewModel.BedCleanInfoList == null)
                    viewModel.BedCleanInfoList = new List<BedCleanInfo>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private List<string> GetEMSUsers()
        {            
            List<User> EMSUserList = FacadeManager.UserInterface.GetUsersByRoleAndFacility(Constants.EMS_USER_ROLE, this.loggedUser.Facility.Id);
            List<EmsStaff> emsStaffList = FacadeManager.UserInterface.FilterEmsStaff(this.loggedUser.Facility);
            List<string> result = (from a in EMSUserList select a.UserName).Distinct().ToList();
            result.AddRange((from a in emsStaffList
                             where !(from b in EMSUserList select b.UserName).Contains(a.UserName)
                             select a.UserName).ToList());

            return (from item in result orderby item select item).ToList();
        }

        #endregion
    }
}
