﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaWorker2;
using System.Threading.Tasks;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.Operations;
using System.Threading;

namespace BMS.VistaIntegration.Managers.Implementation
{
    public class OperationManager : IDisposable, IOperationManager
    {
        private readonly Dictionary<string, Actor> actors = new Dictionary<string, Actor>();
        private object LockThis = new object();
        private volatile bool isDisposed = false;
        private static readonly BmsLogger Logger = new BmsLogger("VistaIntegration OperationManager Message: ");

        public void RunOperation(string vistaId, Task task, VistaDataType dataType)
        {
            Actor actor = null;
            lock (LockThis)
            {
                if (isDisposed) return;
                if (!actors.TryGetValue(vistaId, out actor))
                {
                    actor = new Actor();
                    actors.Add(vistaId, actor);
                }
            }
            Logger.LogFormat(BmsLogger.Level.Info, "Vista Id: {0}", vistaId);
            actor.ExecuteTask(task, dataType);
        }

        public string EndRunTask(string vistaId, Task task)
        {
            Actor actor = null;
            lock (LockThis)
            {
                if (isDisposed) return VistaDataType.None.ToString();
                if (!actors.TryGetValue(vistaId, out actor))
                {
                    actor = new Actor();
                    actors.Add(vistaId, actor);
                }
            }
            Logger.LogFormat(BmsLogger.Level.Info, "Vista Id: {0}", vistaId);
            return actor.EndExecuteTask(task).ToString() + "_" + vistaId;
        }

        public void Dispose()
        {
            lock (LockThis)
            {
                isDisposed = true;
            }            
            actors.Values.ForEach(a => { if (a != null) a.ClearTaskLists(); });
        }
    }
}
