﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using BMS.ServicesWrapper.BMService;

namespace BMS.VistaIntegration.LogCheckers
{
    public class DatabaseLogChecker : IVistaIntegrationLogChecker
    {
        public DatabaseLogChecker() { }

        public bool Exists(VistaIntegrationLog log, string vistaCode)
        {
            IList<VistaIntegrationLog> existsLogs = BMSFactory.BedManagerQueryClientWindows.GetAlreadyExistsVistaIntegrationLogs(Enumerable.Repeat(log, 1), vistaCode);
            return (existsLogs != null && existsLogs.Count > 0);
        }
    }
}
