﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using BMS.Utils;
using BMS.ServicesWrapper.BMService;

namespace BMS.VistaIntegration.Commands
{
    class VistaOperationsCache
    {
        internal static readonly VistaOperationsCache Instance = new VistaOperationsCache();

        private VistaOperationsCache() { } 

        private Dictionary<string, IList<VistaOperation>> cache = new Dictionary<string, IList<VistaOperation>>();
        private object LockThis = new object();

        internal void Update(VistaOperation op)
        {
            lock (LockThis)
            {
                BMSFactory.BedManagerOperationsClientWindows.UpdateData(op);
                if (!cache.ContainsKey(op.VistaSiteId))
                     cache.Add(op.VistaSiteId, BMSFactory.BedManagerOperationsClientWindows.GetData(op.VistaSiteId));
                IList<VistaOperation> list = cache[op.VistaSiteId];
                int index = list.IndexOf(P => P.DataType == op.DataType);
                list[index] = op;
            }
        }

        internal IList<VistaOperation> Get(string vistaId)
        {
            lock (LockThis)
            {
                IList<VistaOperation> result;
                if (cache.TryGetValue(vistaId, out result))
                    return result;

                result = BMSFactory.BedManagerOperationsClientWindows.GetData(vistaId);
                cache[vistaId] = result;
                return result;
            }
        }
    }
}
