﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Security;
using BMS.VistaIntegration.FacadeContracts;
using BMS.Facade;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using FacadeVistASite = BMS.VistaIntegration.FacadeContracts.VistASite;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Cache;
using BMS.VistaIntegration.Commands;
using BMS.Schedulers;

namespace BMS.VistaIntegration.Dal.Schedulers
{
    public class SchedulerDal : ISchedulerDal
    {
        private readonly string domain;

        public SchedulerDal()
        {

            domain = SecurityFactory.InstanceWindows.GetCurrentDomain();

        }


        private void OnVistASite(Dictionary<string, List<SchedulerData>> schedulersDicionary, FacadeVistASite site)
        {

            VistAConnectionInfo connectionInfo = ToConnectionInfo(site);
            AddSchedulerData(schedulersDicionary, site, connectionInfo, DataRetrievalMethod.MDWS, new MdwsVistASessionFactory());
            AddSchedulerData(schedulersDicionary, site, connectionInfo, DataRetrievalMethod.ODBC, new CacheVistASessionFactory());

        }

        private void AddSchedulerData(
            Dictionary<string, List<SchedulerData>> schedulersDicionary,
            FacadeVistASite site,
            VistAConnectionInfo connectionInfo,
            DataRetrievalMethod dataRetrievalMethod,
            IVistASessionFactory sessionFactory
            )
        {

            Dictionary<string, VistaDataType> schedulerTypesDictionary = GetSchedulerTypesDictionary(site, dataRetrievalMethod);
            foreach (string schedulerId in schedulerTypesDictionary.Keys)
            {
                List<SchedulerData> datas = null;
                if (!schedulersDicionary.TryGetValue(schedulerId, out datas))
                {
                    datas = new List<SchedulerData>();
                    schedulersDicionary.Add(schedulerId, datas);
                }
                VistaDataType types = schedulerTypesDictionary[schedulerId];
                SchedulerData data = new SchedulerData(connectionInfo, sessionFactory, types);
                datas.Add(data);
            }

        }

        private VistAConnectionInfo ToConnectionInfo(FacadeVistASite site)
        {

            Data.VistASite vistAsite = new Data.VistASite(site.Id, site.Name,site.TimeZone);
            return new VistAConnectionInfo(
                vistAsite,
                site.MDWSConnection.ConnectionConfiguration,
                site.MDWSConnection.AccesCode,
                site.MDWSConnection.VerifyCode
                );

        }



        private Dictionary<string, VistaDataType> GetSchedulerTypesDictionary(FacadeVistASite site, DataRetrievalMethod dataRetrivalMethod)
        {

            Dictionary<string, VistaDataType> dictionaryToPopulate = new Dictionary<string, VistaDataType>();
            foreach (var type in site.DataRetrievalDetails.Keys)
            {
                var dataRetrival = site.DataRetrievalDetails[type];
                if (dataRetrival.DataRetrievalMethod == dataRetrivalMethod)
                {
                    VistaDataType keyType = (VistaDataType)((int)type);
                    string schedulerId = dataRetrival.JobCalendar.Id;
                    VistaDataType vistAType = VistaDataType.None;
                    dictionaryToPopulate.TryGetValue(schedulerId, out vistAType);
                    vistAType |= keyType;
                    dictionaryToPopulate[schedulerId] = vistAType;
                }
            }
            return dictionaryToPopulate;

        }


        public IEnumerable<CommandData> GetSchedulersCommand()
        {
            IList<FacadeVistASite> sites = FacadeManager.ConfigurationInterfaceWindows.GetVistaSites(domain);
            var schedulersDictionary = new Dictionary<string, List<SchedulerData>>();
            sites.ForEach(s => OnVistASite(schedulersDictionary, s));
            return schedulersDictionary.Select(s => new CommandData(s.Key, s.Value));
        }
    }
}
