﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using BMS.VistaIntegration.Data.WF;


namespace Mdws2ORM.Maps.WF
{
    public class BedSwitchMap : EntityMap<BedSwitch>
    {
        public override string File
        {
            get { return "405"; }
        }

        public override string Location
        {
            get { return "DGPM("; }
        }

        public override BedSwitch NewEntity(string ien)
        {
            return new BedSwitch() { Ien = ien };
        }

        protected override void MapFields()
        {
            MapPointerToFile(".07", (m, s) => m.RoomBedIen = s);
            MapPointerToFile(".06", (m, s) => m.WardIen = s);
        }
    }
}
