﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.EVS
{
    public class OrderableItemMap : EntityMap<OrderableItem>
    {
        public override string Location
        {
            get { return "ORD(101.43,"; }
        }

        public override OrderableItem NewEntity(string ien)
        {
            return new OrderableItem() { IEN = ien };
        }

        public override string File
        {
            get { return "101.43"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
        }
    }
}
