﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.EVS
{
    public class OrderStatusMap : EntityMap<OrderStatus>
    {
        public override string Location
        {
            get { return "ORD(100.01,"; }
        }

        public override OrderStatus NewEntity(string ien)
        {
            return new OrderStatus() { IEN = ien };
        }

        public override string File
        {
            get { return "100.01"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
        }
    }
}
