﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;


namespace Mdws2ORM.Maps.EVS
{
    class FacilityTreatingSpecialtyMap : EntityMap<FacilityTreatingSpecialty>
    {
        public override string Location
        {
            get { return "DIC(45.7,"; }
        }

        public override FacilityTreatingSpecialty NewEntity(string ien)
        {
            return new FacilityTreatingSpecialty() { IEN = ien };
        }

        public override string File
        {
            get { return "45.7"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
            MapPointerToFile("1", (m, s) => m.SpecialtyId = s);
        }
    }
}
