﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.EIS
{
    public class HospitalLocationMap : EntityMap<HospitalLocation>
    {

        public override string File
        {
            get { return "44"; }
        }

        public override string Location
        {
            get { return "SC("; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (e, value) => e.Name = value);
            MapFreeText("1", (e, value) => e.Abbreviation = value);
            MapFreeText("99", (e, value) => e.Telephone = value);
            MapPointerToFile<WardLocation>("42", (m, s) => m.WardLocationId = s, (m, s) => m.WardLocation = s);
        }

        public override HospitalLocation NewEntity(string ien)
        {
            return new HospitalLocation() { IEN = ien };
        }
    }
}
