﻿using System.Net.Mail;
using System;
using System.Threading;
using System.ComponentModel;

namespace BMS.Utils
{
    public static class SendMail
    {
        public static SendMailAsyncResult Execute(string from, string to, string subject, string body, string smtpHost, int smtpPort, AsyncCallback callback)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (smtpHost != null && smtpHost.Equals(Constants.NONE, StringComparison.InvariantCultureIgnoreCase))
                    return null;
                MailMessage message = new MailMessage();
                message.From = new MailAddress(from);
                message.To.Add(to);
                message.Subject = subject;
                message.Body = body;
                message.IsBodyHtml = false;

                SmtpClient client = new SmtpClient();
                if (string.IsNullOrEmpty(smtpHost))
                {
                    client.DeliveryMethod = SmtpDeliveryMethod.PickupDirectoryFromIis;
                }
                else
                {
                    client.Host = smtpHost;
                    client.Port = smtpPort;
                    client.DeliveryMethod = SmtpDeliveryMethod.Network;
                }
                //client.EnableSsl = true;

                client.UseDefaultCredentials = true;
                //client.UseDefaultCredentials = false;

                var sendMailAsyncResult = new SendMailAsyncResult(client, message, callback);
                return sendMailAsyncResult;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public class SendMailAsyncResult : IAsyncResult
        {
            SmtpClient client;
            AsyncCallback callback;
            EventWaitHandle asyncWaitHandle;
            MailMessage message;

            public bool CompletedSynchronously { get { return false; } }
            public WaitHandle AsyncWaitHandle { get { return this.asyncWaitHandle; } }
            public bool IsCompleted { get { return true; } }
            public SmtpClient Client { get { return client; } }


            public SendMailAsyncResult(SmtpClient client, MailMessage message, AsyncCallback callback/*, object state*/)
            {
                this.client = client;
                this.callback = callback;
                this.message = message;
                this.asyncWaitHandle = new EventWaitHandle(false, EventResetMode.AutoReset);
                ThreadPool.QueueUserWorkItem(SendAsync, this);
            }

            void SendAsync(object state)
            {
                SendMailAsyncResult sender = state as SendMailAsyncResult;
                Exception error = null;
                try
                {
                    sender.client.Send(sender.message);
                }
                catch (Exception e)
                {
                    error = e;
                }
                finally
                {
                    sender.SendCompleted(sender.Client, new AsyncCompletedEventArgs(error, false, sender));
                }
            }

            void SendCompleted(object sender, AsyncCompletedEventArgs e)
            {
                this.asyncWaitHandle.Set();
                if (e.Error != null)
                    Tracer.TraceException(e.Error);
                if (callback != null)
                    callback(this);
            }

            public object AsyncState
            {
                get { return null; }
            }
        }
    }
}
